/* global define */

/**
 * Show mail connectivity log model
 *
 */

define("JEP/MailProcessingLogModel", [
    "jquery",
    "underscore",
    "backbone",
    "JEP/shared/ajax",
    "JEP/MailLogUtils"
], function (
    $,
    _,
    Backbone,
    Ajax,
    MailLogUtils
) {

    return Backbone.Model.extend({

        events: {
            getProcessingLogDone: "getProcessingLogDone",
            getProcessingLogFailed: "getProcessingLogFailed"
        },

        defaults: function () {
            return {
                data:[{
                    "id": 0,
                    "mailChannelId": 0,
                    "mailItemId": 0,
                    "handlerNameKey": "",
                    "resultStatus": "",
                    "message": "",
                    "fromAddress": "",
                    "mailChannelName": "",
                    "subject": "",
                    "issueKey": "",
                    "noOfRetry": 0,
                    "updatedDateTime": "",
                    "createdDateTime": ""
                }],
                totalPages: 1
            };
        },

        setData: function (res) {
            _.each(res.data, function (ele) {

                ele.resultStatus = MailLogUtils.renderLogStatus(ele.resultStatus);

            }, this);

            this.set(res);
        },

        getProcessingLogForChannel: function (channelKey, pageLimit, currentPage) {
            var url = this._getProcessingLogUrl(channelKey, pageLimit, currentPage);
            this._handleProcessingLog(Ajax.get(url));
        },

        _getProcessingLogUrl: function (channelKey, pageLimit, currentPage) {
            var baseUrl = AJS.contextPath() + "/rest/jira-email-processor-plugin/1.0/mail/audit/process/" + channelKey;
            return baseUrl + "?limit=" + pageLimit + "&page=" + currentPage;
        },

        _handleProcessingLog: function (ajax) {
            ajax.done(_.bind(function (data) {
                this.setData(data);
                this.trigger(this.events.getProcessingLogDone);
            }, this))
                .fail(_.bind(function (xhr) {
                    this.trigger(this.events.getProcessingLogFailed, Ajax.getErrorMessage(xhr));
                }, this));
        }

    });

});