/* global define */

/**
 * Show mail log utilities
 *
 */

define("JEP/MailLogUtils", [
    "jquery",
    "underscore",
    "exports"
], function (
    $,
    _,
    Exports
) {

    function renderLogStatus(status) {
        if (status === "SUCCESS") {
            return "<span class='aui-lozenge aui-lozenge-subtle'>" +
                AJS.I18n.getText("jep.mail.log.component.outcome.success") + "</span>";
        }
        if (status === "ACCEPTED") {
            return "<span class='aui-lozenge aui-lozenge-subtle'>" +
                AJS.I18n.getText("jep.mail.log.component.outcome.accepted") + "</span>";
        }
        if (status === "FAILURE" || status === "FAILED") {
            return "<span class='aui-lozenge aui-lozenge-error'>" +
                AJS.I18n.getText("jep.mail.log.component.outcome.failure") + "</span>";
        }
        if (status === "REJECTED") {
            return "<span class='aui-lozenge aui-lozenge-current'>" +
                AJS.I18n.getText("jep.mail.log.component.outcome.rejected") + "</span>";
        }
        if (status === "SKIPPED") {
            return "<span class='aui-lozenge aui-lozenge-current'>" + AJS.I18n.getText("jep.mail.log.component.outcome.skipped") + "</span>";
        }
        if (status === "SUSPENDED") {
            return "<span class='aui-lozenge'>" + AJS.I18n.getText("jep.mail.log.component.outcome.suspended") + "</span>";
        }
        if (status === "ENABLED") {
            return "<span class='aui-lozenge aui-lozenge-subtle'>" +
                AJS.I18n.getText("jep.mail.log.component.outcome.enabled") + "</span>";
        }
        if (status === "DISABLED") {
            return "<span class='aui-lozenge aui-lozenge-current'>" +
                AJS.I18n.getText("jep.mail.log.component.outcome.disabled") + "</span>";
        }
        return status;
    }

    Exports.renderLogStatus = renderLogStatus;

});