/* global define */

/**
 * Show mail log model
 *
 */

define("JEP/MailConnectivityLogModel", [
    "jquery",
    "underscore",
    "backbone",
    "JEP/shared/ajax",
    "JEP/MailLogUtils"
], function (
    $,
    _,
    Backbone,
    Ajax,
    MailLogUtils
) {

    return Backbone.Model.extend({

        events: {
            getConnectivityLogDone: "getConnectivityLogDone",
            getConnectivityLogFailed: "getConnectivityLogFailed"
        },

        defaults: function () {
            return {
                data: [{
                    "id": 0,
                    "mailConnectionId": 0,
                    "mailChannelName": "",
                    "failureMessage": "",
                    "noOfRetry": 0,
                    "runOutcome": "",
                    "createdDateTime": "",
                    "updatedDateTime": ""
                }],
                totalPages: 1
            };
        },

        setData: function (res) {
            _.each(res.data, function (ele) {

                ele.runOutcome = MailLogUtils.renderLogStatus(ele.runOutcome);

            }, this);

            this.set(res);
        },

        getConnectivity: function (pageLimit, currentPage) {
            var url = this._getConnectivityUrl(pageLimit, currentPage);
            this._handleConnectivity(Ajax.get(url));
        },

        getConnectivityForChannel: function (channelKey, pageLimit, currentPage) {
            var url = this._getConnectivityForChannelUrl(channelKey, pageLimit, currentPage);
            this._handleConnectivity(Ajax.get(url));
        },

        _getConnectivityUrl: function (pageLimit, currentPage) {
            var baseUrl = AJS.contextPath() + "/rest/jira-email-processor-plugin/1.0/mail/audit/connectivity/";
            return baseUrl + "?limit=" + pageLimit + "&page=" + currentPage;
        },

        _getConnectivityForChannelUrl: function (channelKey, pageLimit, currentPage) {
            var baseUrl = AJS.contextPath() + "/rest/jira-email-processor-plugin/1.0/mail/audit/connectivity/" + channelKey;
            return baseUrl + "?limit=" + pageLimit + "&page=" + currentPage;
        },

        _handleConnectivity: function (ajax) {
            ajax.done(_.bind(function (data) {
                this.setData(data);
                this.trigger(this.events.getConnectivityLogDone);
            }, this))
                .fail(_.bind(function (xhr) {
                    this.trigger(this.events.getConnectivityLogFailed, Ajax.getErrorMessage(xhr));
                }, this));
        }

    });

});