/* globals define, AJS */
define('JEP/shared/ajax', [
    'underscore',
    'exports'
], function (
    _,
    exports
) {

    function prepareParams(url, type, dataType, contentType, success, error) {
        return {
            url: url,
            type: type,
            dataType: dataType,
            contentType: contentType,
            complete: function (xhr, textStatus, smartAjaxResult) {
                if (smartAjaxResult.successful && success) {
                    success(xhr, textStatus, smartAjaxResult);
                } else if (error) {
                    error(xhr, textStatus, smartAjaxResult);
                }
            }
        };
    }

    function get(url, success, error) {
        var params = prepareParams(url, "GET", "json", "application/json", success, error);

        if (_.isObject(url)) {
            params = _.extend(params, url);
        } else {
            params.url = url;
        }

        return JIRA.SmartAjax.makeRequest(params);
    }

    function post(url, data, success, error) {
        return _post("json", url, data, success, error);
    }

    function postForHtml(url, data, success, error) {
        return _post("html", url, data, success, error);
    }

    function _post(dataType, url, data, success, error) {
        var params = prepareParams(url, "POST", dataType, "application/json", success, error);

        params.data = JSON.stringify(data);
        params.timeout = 180000; // Seriously, any slower and we are doing something REALLY WRONG

        return JIRA.SmartAjax.makeRequest(params);
    }

    function put(url, data, success, error) {
        var params = prepareParams(url, "PUT", "json", "application/json", success, error);
        params.data = JSON.stringify(data);

        return JIRA.SmartAjax.makeRequest(params);
    }

    function del(url, success, error) {
        var params = prepareParams(url, "DELETE", "json", "application/json", success, error);

        return JIRA.SmartAjax.makeRequest(params);
    }

    exports.get = get;
    exports.post = post;
    exports.postForHtml = postForHtml;
    exports.put = put;
    exports.del = del;

    /**
     * Get error message from xhr object returned from server
     *
     * If no message found, it will return
     */
    exports.getErrorMessage = function getErrorMessage(xhr) {
        var errorMessage = null;
        try {
            var errorCollection = JSON.parse(xhr.responseText);
            if (errorCollection.errorMessages) {
                errorMessage = errorCollection.errorMessages[0]
            }
        } catch (e) {
            // no need to do anything
        }
        return errorMessage || AJS.I18n.getText("jep.error.ajax.general");
    }
});