/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.internal.mail.processor.visiblefortest;

import com.atlassian.jira.internal.mail.processor.feature.channel.MailChannelDTO;
import com.atlassian.jira.internal.mail.processor.feature.channel.MailChannelManager;
import com.atlassian.jira.internal.mail.processor.feature.connection.MailConnectionDTO;
import com.atlassian.jira.internal.mail.processor.feature.connection.MailConnectionManager;
import com.atlassian.jira.internal.mail.processor.feature.property.MailGlobalSettingManager;
import com.atlassian.jira.internal.mail.processor.feature.puller.MailPullerWorker;
import com.atlassian.jira.internal.mail.processor.feature.puller.mailitem.MailItemDTO;
import com.atlassian.jira.internal.mail.processor.feature.puller.mailitem.MailItemManager;
import com.atlassian.jira.internal.mail.processor.visiblefortest.MailPullerBackdoor;
import com.atlassian.jira.mail.processor.api.channel.ChannelKey;
import com.atlassian.jira.mail.processor.api.handler.result.FailHandlerResult;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.mail.MailUtils;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.stream.CloseableIterable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import javax.mail.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
@VisibleForTesting
public class MailPullerBackdoorImpl
implements MailPullerBackdoor {
    private final MailItemManager mailItemManager;
    private final MailPullerWorker mailPullerWorker;
    private final MailConnectionManager mailConnectionManager;
    private final MailGlobalSettingManager mailGlobalSettingManager;
    private final MailChannelManager mailChannelManager;
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public MailPullerBackdoorImpl(MailItemManager mailItemManager, MailPullerWorker mailPullerWorker, MailConnectionManager mailConnectionManager, MailGlobalSettingManager mailGlobalSettingManager, MailChannelManager mailChannelManager, DatabaseAccessor databaseAccessor) {
        this.mailItemManager = mailItemManager;
        this.mailPullerWorker = mailPullerWorker;
        this.mailConnectionManager = mailConnectionManager;
        this.mailGlobalSettingManager = mailGlobalSettingManager;
        this.mailChannelManager = mailChannelManager;
        this.databaseAccessor = databaseAccessor;
    }

    @Override
    public void pullMail() {
        this.mailPullerWorker.pullMailFromAllValidChannels();
    }

    @Override
    public int pullMailByMailChannelKey(String mailChannelKey) {
        ChannelKey key = ChannelKey.from((String)mailChannelKey);
        Option mailChannelDTOOption = this.mailChannelManager.getMailChannelByKey(Option.none(), key);
        int pulledMailCount = 0;
        if (mailChannelDTOOption.isDefined()) {
            Option mailConnectionById = this.mailConnectionManager.getMailConnectionById(Option.none(), ((MailChannelDTO)mailChannelDTOOption.get()).getMailConnectionId());
            pulledMailCount = this.mailPullerWorker.pullEmailForConnection((MailConnectionDTO)mailConnectionById.get(), ignored -> FailHandlerResult.abstain());
        }
        return pulledMailCount;
    }

    @Override
    public JSONArray getUnprocessedMailItemsByChannelKey(String mailChannelKey) {
        ChannelKey key = ChannelKey.from((String)mailChannelKey);
        Option mailChannelDTOOption = this.mailChannelManager.getMailChannelByKey(Option.none(), key);
        if (mailChannelDTOOption.isDefined()) {
            List mailItemDTOList = (List)this.databaseAccessor.runInNewTransaction(databaseConnection -> {
                try (CloseableIterable mailItemDTOs = this.mailItemManager.streamUnprocessedItems(databaseConnection, ((MailChannelDTO)mailChannelDTOOption.get()).getMailConnectionId(), 20L);){
                    ArrayList arrayList = Lists.newArrayList((Iterable)mailItemDTOs);
                    return arrayList;
                }
            });
            return this.toJson(mailItemDTOList);
        }
        return new JSONArray();
    }

    private JSONArray toJson(List<MailItemDTO> mailItemDTOList) {
        JSONArray jsonArray = new JSONArray();
        try {
            for (MailItemDTO mailItemDTO : mailItemDTOList) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("subject", (Object)mailItemDTO.getMimeMsg().getSubject());
                jsonObject.put("body", (Object)MailUtils.getBody((Message)mailItemDTO.getMimeMsg()));
                jsonObject.put("receivedDate", (Object)mailItemDTO.getMimeMsg().getReceivedDate());
                jsonObject.put("from", (Object)mailItemDTO.getMimeMsg().getFrom());
                jsonArray.put((Object)jsonObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonArray;
    }

    @Override
    public void setGlobalMailPullerSettingFlag(boolean flag) {
        this.mailGlobalSettingManager.setGlobalPullerJobState(flag);
    }

    @Override
    public boolean isGlobalPullerJobOn() {
        return this.mailGlobalSettingManager.isGlobalPullerJobOn();
    }
}

