/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.internal.mail.processor.visiblefortest;

import com.atlassian.jira.internal.mail.processor.feature.audit.mailitem.MailItemAuditDTO;
import com.atlassian.jira.internal.mail.processor.feature.audit.mailitem.MailItemAuditManager;
import com.atlassian.jira.internal.mail.processor.feature.channel.MailChannelDTO;
import com.atlassian.jira.internal.mail.processor.feature.channel.MailChannelManager;
import com.atlassian.jira.internal.mail.processor.feature.processor.MailProcessorService;
import com.atlassian.jira.internal.mail.processor.feature.puller.mailitem.MailItemDTO;
import com.atlassian.jira.internal.mail.processor.feature.puller.mailitem.MailItemManager;
import com.atlassian.jira.internal.mail.processor.visiblefortest.MailProcessorBackdoor;
import com.atlassian.jira.mail.processor.api.channel.ChannelKey;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
@VisibleForTesting
public class MailProcessorBackdoorImpl
implements MailProcessorBackdoor {
    private final MailItemManager mailItemManager;
    private final MailItemAuditManager mailItemAuditManager;
    private final MailChannelManager mailChannelManager;
    private final MailProcessorService mailProcessorService;

    @Autowired
    public MailProcessorBackdoorImpl(MailItemManager mailItemManager, MailItemAuditManager mailItemAuditManager, MailChannelManager mailChannelManager, MailProcessorService mailProcessorService) {
        this.mailItemManager = mailItemManager;
        this.mailItemAuditManager = mailItemAuditManager;
        this.mailChannelManager = mailChannelManager;
        this.mailProcessorService = mailProcessorService;
    }

    @Override
    public void process() {
        this.mailProcessorService.run();
    }

    @Override
    public JSONArray getMailItems(String mailChannelKey) {
        ChannelKey key = ChannelKey.from((String)mailChannelKey);
        MailChannelDTO mailChannelDTO = (MailChannelDTO)this.mailChannelManager.getMailChannelByKey(Option.none(), key).getOrNull();
        JSONArray jsonArray = new JSONArray();
        if (mailChannelDTO != null) {
            List mailItemDTOList = this.mailItemManager.getMailItems();
            List mailItemAuditDTOList = this.mailItemAuditManager.getMailItemAudits(0L, 0L);
            try {
                for (MailItemDTO mailItemDTO : mailItemDTOList) {
                    if (mailItemDTO.getMailConnectionId() != mailChannelDTO.getMailConnectionId()) continue;
                    JSONObject jsonObject = new JSONObject();
                    JSONObject audit = new JSONObject();
                    jsonObject.put("id", mailItemDTO.getId());
                    jsonObject.put("status", (Object)mailItemDTO.getStatus());
                    jsonObject.put("audit", (Object)audit);
                    for (MailItemAuditDTO mailItemAuditDTO : mailItemAuditDTOList) {
                        if (mailItemAuditDTO.getMailItemId() != mailItemDTO.getId()) continue;
                        audit.put(mailItemAuditDTO.getHandlerNameKey(), (Object)mailItemAuditDTO.getResultStatus());
                    }
                    jsonArray.put((Object)jsonObject);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return jsonArray;
    }
}

