/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.internal.mail.processor.visiblefortest;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.internal.mail.processor.feature.channel.MailChannelDTO;
import com.atlassian.jira.internal.mail.processor.feature.channel.MailChannelManager;
import com.atlassian.jira.internal.mail.processor.feature.connection.MailConnectionDTO;
import com.atlassian.jira.internal.mail.processor.feature.connection.MailConnectionManager;
import com.atlassian.jira.internal.mail.processor.feature.handler.MailHandlerDTO;
import com.atlassian.jira.internal.mail.processor.feature.handler.MailHandlerManager;
import com.atlassian.jira.internal.mail.processor.visiblefortest.MailChannelServiceBackdoor;
import com.atlassian.jira.internal.mail.processor.visiblefortest.mock.MockProject;
import com.atlassian.jira.internal.mail.processor.visiblefortest.request.ConnectionDefinitionRequest;
import com.atlassian.jira.internal.mail.processor.visiblefortest.request.MailChannelRequest;
import com.atlassian.jira.internal.mail.processor.visiblefortest.request.ProjectRequest;
import com.atlassian.jira.mail.processor.api.channel.ChannelDefinition;
import com.atlassian.jira.mail.processor.api.channel.ChannelDefinitionBuilder;
import com.atlassian.jira.mail.processor.api.channel.ChannelKey;
import com.atlassian.jira.mail.processor.api.channel.ChannelManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
@VisibleForTesting
public class MailChannelServiceBackdoorImpl
implements MailChannelServiceBackdoor {
    private final MailConnectionManager mailConnectionManager;
    private final MailChannelManager mailChannelManager;
    private final MailHandlerManager mailHandlerManager;
    private final ChannelManager channelManager;

    @Autowired
    public MailChannelServiceBackdoorImpl(MailConnectionManager mailConnectionManager, MailChannelManager mailChannelManager, MailHandlerManager mailHandlerManager, ChannelManager channelManager) {
        this.mailConnectionManager = mailConnectionManager;
        this.mailChannelManager = mailChannelManager;
        this.mailHandlerManager = mailHandlerManager;
        this.channelManager = channelManager;
    }

    @Override
    public Response createMailChannel(String requestJson) {
        Gson gson = new Gson();
        MailChannelRequest mailChannelRequest = (MailChannelRequest)gson.fromJson(requestJson, MailChannelRequest.class);
        Either result = this.channelManager.createMailChannel(this.fromRequest(mailChannelRequest));
        return this.toResponse((Either<AnError, ChannelDefinition>)result);
    }

    @Override
    public Response createMailChannelForProject(String requestJson) {
        Gson gson = new Gson();
        MailChannelRequest mailChannelRequest = (MailChannelRequest)gson.fromJson(requestJson, MailChannelRequest.class);
        Either result = this.channelManager.createProjectMailChannel(this.fromRequest(mailChannelRequest.getProjectRequest()), this.fromRequest(mailChannelRequest));
        return this.toResponse((Either<AnError, ChannelDefinition>)result);
    }

    @Override
    public void deleteMailChannel(String channelKey) {
        this.channelManager.deleteMailChannel(ChannelKey.from((String)channelKey));
    }

    @Override
    public JSONObject getMailChannelDetail(String channelKey) {
        JSONObject result = new JSONObject();
        try {
            Option mailChannelDTOOption = StepsConverters.olderOption((io.atlassian.fugue.Option)this.mailChannelManager.getMailChannelByKey(ChannelKey.from((String)channelKey)));
            if (mailChannelDTOOption.isDefined()) {
                MailChannelDTO mailChannelDTO = (MailChannelDTO)mailChannelDTOOption.get();
                Option mailConnectionDTOOption = StepsConverters.olderOption((io.atlassian.fugue.Option)this.mailConnectionManager.getMailConnectionById(mailChannelDTO.getMailConnectionId()));
                List mailHandlerDTOList = this.mailHandlerManager.getMailHandlersAndFiltersByChannelId(mailChannelDTO.getId());
                result = this.channelDetailToJSON((MailChannelDTO)mailChannelDTOOption.get(), (MailConnectionDTO)mailConnectionDTOOption.get(), mailHandlerDTOList);
            } else {
                result.put("error", (Object)String.format("Mail channel not found for %s", channelKey));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public JSONObject getMailChannelByKey(String channelKey) {
        JSONObject result = new JSONObject();
        Option mailChannelDefinitionOption = this.channelManager.getMailChannelByKey(ChannelKey.from((String)channelKey));
        try {
            if (mailChannelDefinitionOption.isDefined()) {
                ChannelDefinition mailChannel = (ChannelDefinition)mailChannelDefinitionOption.get();
                result = this.toJSON(mailChannel);
            } else {
                result.put("error", (Object)String.format("Mail channel not found for %s", channelKey));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Response updateMailChannel(String requestJson) {
        Gson gson = new Gson();
        MailChannelRequest mailChannelRequest = (MailChannelRequest)gson.fromJson(requestJson, MailChannelRequest.class);
        Either result = this.channelManager.update(this.fromRequest(mailChannelRequest));
        return this.toResponse((Either<AnError, ChannelDefinition>)result);
    }

    private Response toResponse(Either<AnError, ChannelDefinition> operationResult) {
        if (operationResult.isRight()) {
            return Response.ok((Object)("{\"key\":\"" + ((ChannelDefinition)operationResult.right().get()).getChannelKey().getKey() + "\"}")).build();
        }
        return Response.ok((Object)("{\"error\":\"" + ((AnError)operationResult.left().get()).getMessage().getMessage() + "\"}")).build();
    }

    private ChannelDefinition fromRequest(MailChannelRequest mailChannelRequest) {
        ConnectionDefinitionRequest request = mailChannelRequest.getConnectionDefinitionRequest();
        ChannelDefinitionBuilder builder = ChannelDefinition.builder().setHandlerModuleCompleteKey(mailChannelRequest.getHandlerComponentKeyRequest().getHandler()).setConnectionDefinition(request.getHostName(), request.getPort(), request.getProtocol(), request.isTls(), request.getUserName(), request.getPassword(), request.getEmailAddress(), request.getPullFromDate()).setEnabled(mailChannelRequest.isEnabled()).setMaxRetryOnFailure(mailChannelRequest.getMaxRetryOnFailure());
        if (StringUtils.isNotBlank((String)mailChannelRequest.getChannelKey())) {
            builder.setChannelKey(ChannelKey.from((String)mailChannelRequest.getChannelKey()));
        }
        if (StringUtils.isNotBlank((String)request.getFolder())) {
            builder.setFolder(request.getFolder());
        }
        if (mailChannelRequest.getHandlerComponentKeyRequest().getFilters() != null) {
            builder.setFilterModuleCompleteKeyList(mailChannelRequest.getHandlerComponentKeyRequest().getFilters());
        }
        Option projectOption = mailChannelRequest.getProjectRequest() == null ? Option.none() : Option.some((Object)this.fromRequest(mailChannelRequest.getProjectRequest()));
        builder.setProject(projectOption);
        return builder.build();
    }

    private Project fromRequest(ProjectRequest projectRequest) {
        return new MockProject(projectRequest.getId(), projectRequest.getKey(), projectRequest.getName());
    }

    private JSONObject channelDetailToJSON(MailChannelDTO mailChannelDTO, MailConnectionDTO mailConnectionDTO, List<MailHandlerDTO> mailHandlerDTOList) throws JSONException {
        JSONObject result = new JSONObject();
        JSONArray handlers = new JSONArray();
        for (MailHandlerDTO mailHandlerDTO : mailHandlerDTOList) {
            JSONObject mailHandlerDTOJson = new JSONObject();
            mailHandlerDTOJson.put("handler-id", mailHandlerDTO.getId());
            mailHandlerDTOJson.put("handler-handlertype", (Object)mailHandlerDTO.getHandlerType());
            mailHandlerDTOJson.put("handler-modulecompletekey", (Object)mailHandlerDTO.getModuleCompleteKey());
            handlers.put((Object)mailHandlerDTOJson);
        }
        result.put("channel-id", mailChannelDTO.getId());
        result.put("channel-key", (Object)mailChannelDTO.getMailChannelKey());
        result.put("channel-mail-connection-id", mailChannelDTO.getMailConnectionId());
        result.put("channel-mail-enabled", mailChannelDTO.isEnabled());
        result.put("channel-project-id", mailChannelDTO.getProjectIdOption().getOrElse((Object)0L));
        result.put("channel-max-retry-on-failure", mailChannelDTO.getMaxRetryOnFailure());
        result.put("mail-connection-username", (Object)mailConnectionDTO.getUserName());
        result.put("mail-connection-emailaddress", (Object)mailConnectionDTO.getEmailAddress());
        result.put("mail-connection-hostname", (Object)mailConnectionDTO.getHostName());
        result.put("mail-connection-port", mailConnectionDTO.getPort());
        result.put("mail-connection-protocol", (Object)mailConnectionDTO.getProtocol());
        result.put("mail-connection-folder", (Object)mailConnectionDTO.getFolder());
        result.put("mail-connection-tls", mailConnectionDTO.isTls());
        result.put("mail-connection-timeout", mailConnectionDTO.getTimeout());
        result.put("handlers", (Object)handlers);
        return result;
    }

    private JSONObject toJSON(ChannelDefinition mailChannel) throws JSONException {
        JSONObject result = new JSONObject();
        result.put("channel-key", (Object)mailChannel.getChannelKey().getKey());
        result.put("channel-mail-enabled", mailChannel.isEnabled());
        result.put("channel-project-id", mailChannel.getProject().isEmpty() ? 0L : ((Project)mailChannel.getProject().get()).getId());
        result.put("channel-max-retry-on-failure", mailChannel.getMaxRetryOnFailure());
        result.put("mail-connection-username", (Object)mailChannel.getChannelConnectionDefinition().getUserName());
        result.put("mail-connection-emailaddress", (Object)mailChannel.getChannelConnectionDefinition().getEmailAddress());
        result.put("mail-connection-hostname", (Object)mailChannel.getChannelConnectionDefinition().getHostName());
        result.put("mail-connection-port", mailChannel.getChannelConnectionDefinition().getPort());
        result.put("mail-connection-protocol", (Object)mailChannel.getChannelConnectionDefinition().getProtocol());
        result.put("mail-connection-folder", (Object)mailChannel.getChannelConnectionDefinition().getFolder());
        result.put("mail-connection-tls", mailChannel.getChannelConnectionDefinition().isTls());
        result.put("mail-connection-timeout", mailChannel.getChannelConnectionDefinition().getTimeout());
        result.put("handler", (Object)mailChannel.getHandlerModuleCompleteKey());
        result.put("filters", (Object)mailChannel.getFilterModuleCompleteKeyList());
        return result;
    }
}

