/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.internal.mail.processor.rest.response;

import com.atlassian.jira.internal.mail.processor.errors.ErrorHelper;
import com.atlassian.jira.internal.mail.processor.errors.MailError;
import com.atlassian.jira.internal.mail.processor.rest.response.ErrorResponse;
import io.atlassian.fugue.Either;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResponseBuilder {
    private final ErrorHelper errorHelper;

    @Autowired
    public ResponseBuilder(ErrorHelper errorHelper) {
        this.errorHelper = errorHelper;
    }

    public Response error(MailError error) {
        return Response.status((Response.Status)error.getResponseStatus()).entity((Object)ErrorResponse.of(this.errorHelper.toMessage(error))).build();
    }

    public Response success(Object result) {
        return Response.ok((Object)result).build();
    }

    public Response parse(Either<MailError, ?> result) {
        return (Response)result.fold(this::error, this::success);
    }
}

