/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.internal.mail.processor.rest;

import com.atlassian.jira.internal.mail.processor.errors.MailError;
import com.atlassian.jira.internal.mail.processor.feature.audit.MailAuditService;
import com.atlassian.jira.internal.mail.processor.feature.channel.MailChannelDTO;
import com.atlassian.jira.internal.mail.processor.feature.channel.MailChannelService;
import com.atlassian.jira.internal.mail.processor.feature.connection.MailConnectionService;
import com.atlassian.jira.internal.mail.processor.rest.MailAuditResource;
import com.atlassian.jira.internal.mail.processor.rest.response.PaginationResponse;
import com.atlassian.jira.internal.mail.processor.rest.response.ResponseBuilder;
import com.atlassian.jira.internal.mail.processor.rest.response.auditlog.AuditLogTransformer;
import com.atlassian.jira.internal.mail.processor.rest.response.auditlog.ProcessingLogResponse;
import com.atlassian.jira.internal.mail.processor.util.DateFormatter;
import com.atlassian.jira.internal.mail.processor.util.DateFormatterFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="mail/audit/process")
public class MailAuditProcessResource
extends MailAuditResource {
    public MailAuditProcessResource(JiraAuthenticationContext authenticationContext, MailAuditService mailAuditService, ResponseBuilder responseBuilder, DateFormatterFactory dateFormatterFactory, MailChannelService mailChannelService, MailConnectionService mailConnectionService) {
        super(authenticationContext, mailAuditService, responseBuilder, dateFormatterFactory, mailChannelService, mailConnectionService);
    }

    @Path(value="{channelKey}")
    @GET
    public Response getProcessingLogByMailChannel(@PathParam(value="channelKey") String channelKey, @QueryParam(value="page") long page, @QueryParam(value="limit") long limit) {
        ApplicationUser currentUser = this.getCurrentUser();
        DateFormatter dateFormatter = this.dateFormatterFactory.forUser(currentUser);
        Either mailChannelEither = this.mailChannelService.getMailChannelByKey(currentUser, channelKey);
        if (mailChannelEither.isLeft()) {
            return this.responseBuilder.error((MailError)mailChannelEither.left().get());
        }
        MailChannelDTO mailChannel = (MailChannelDTO)mailChannelEither.right().get();
        Either projectEither = this.mailChannelService.getProjectByMailChannel(currentUser, mailChannel);
        if (projectEither.isLeft()) {
            return this.responseBuilder.error((MailError)projectEither.left().get());
        }
        Option projectOption = (Option)projectEither.right().get();
        Either processingLogEither = this.mailAuditService.getProcessingLogByMailChannel(currentUser, projectOption, mailChannel, this.getOffset(page, limit), this.getSafeLimit(limit));
        if (processingLogEither.isLeft()) {
            return this.responseBuilder.error((MailError)processingLogEither.left().get());
        }
        Either totalPagesEither = this.mailAuditService.getTotalPageForProcessingLogByChannel(currentUser, projectOption, mailChannel, this.getSafeLimit(limit));
        if (totalPagesEither.isLeft()) {
            return this.responseBuilder.error((MailError)totalPagesEither.left().get());
        }
        int totalPages = ((Long)totalPagesEither.right().get()).intValue();
        Collection<ProcessingLogResponse> data = AuditLogTransformer.buildProcessingLogResponse(dateFormatter, (Collection)processingLogEither.right().get());
        return this.responseBuilder.success(new PaginationResponse(data, totalPages));
    }
}

