/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.internal.mail.processor.handler.info;

import com.atlassian.jira.internal.mail.processor.descriptor.MailFilterModuleDescriptor;
import com.atlassian.jira.mail.processor.api.handler.info.MailFilterInfo;
import com.atlassian.jira.mail.processor.api.handler.info.MailFilterInfoProvider;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class MailFilterInfoProviderImpl
implements MailFilterInfoProvider {
    private final PluginAccessor pluginAccessor;
    private final I18nHelper i18nHelper;

    @Autowired
    public MailFilterInfoProviderImpl(PluginAccessor pluginAccessor, I18nHelper i18nHelper) {
        this.pluginAccessor = pluginAccessor;
        this.i18nHelper = i18nHelper;
    }

    public List<MailFilterInfo> getInfoForAvailableMailFilters() {
        ArrayList<MailFilterInfo> mailFilterInfoList = new ArrayList<MailFilterInfo>();
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(MailFilterModuleDescriptor.class);
        for (MailFilterModuleDescriptor descriptor : descriptors) {
            MailFilterInfo info = new MailFilterInfo(this.i18nHelper.getText(descriptor.getI18nNameKey()), descriptor.getCompleteKey());
            mailFilterInfoList.add(info);
        }
        return mailFilterInfoList;
    }
}

