/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.timedpromise.internal.store.rows;

import com.atlassian.scheduler.timedpromise.internal.schema.querydsl.QKeyComponent;
import com.atlassian.scheduler.timedpromise.internal.schema.querydsl.QKeyComponentOracleHack;
import com.atlassian.scheduler.timedpromise.internal.schema.querydsl.QTimedPromise;
import com.atlassian.scheduler.timedpromise.internal.store.rows.ComponentRow;
import com.atlassian.scheduler.timedpromise.internal.store.rows.TimedPromiseRow;
import com.atlassian.util.concurrent.Assertions;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import io.atlassian.fugue.Option;

public class TimedPromiseWithComponentRow {
    private final TimedPromiseRow timedPromiseRow;
    private final Option<ComponentRow> componentRow;

    private TimedPromiseWithComponentRow(TimedPromiseRow timedPromiseRow, ComponentRow componentRow) {
        this.timedPromiseRow = (TimedPromiseRow)Assertions.notNull((String)"timedPromiseRow", (Object)timedPromiseRow);
        this.componentRow = Option.option((Object)componentRow);
    }

    public static TimedPromiseWithComponentRow fromDatabase(QTimedPromise promiseTable, QKeyComponent keyComponentTable, Tuple row) {
        Assertions.notNull((String)"promiseTable is required", (Object)((Object)promiseTable));
        Assertions.notNull((String)"keyComponentTable is required", (Object)((Object)keyComponentTable));
        Assertions.notNull((String)"row is required", (Object)row);
        return new TimedPromiseWithComponentRow(TimedPromiseRow.fromDatabase(promiseTable, row), TimedPromiseWithComponentRow.getComponentRow(keyComponentTable, row));
    }

    private static ComponentRow getComponentRow(QKeyComponent keyComponentTable, Tuple row) {
        if (row.get(QKeyComponentOracleHack.ALIAS_ID) == null) {
            return null;
        }
        return ComponentRow.fromDatabase(keyComponentTable, row);
    }

    public static Expression<?>[] getColumns(QTimedPromise promiseTable, QKeyComponent keyComponentTable) {
        return new Expression[]{promiseTable.ID, promiseTable.TASK_KEY, promiseTable.CLASSIFICATION, promiseTable.KEY_HASH, promiseTable.TARGET_TIME_MILLIS, promiseTable.STATUS, promiseTable.MIME_TYPE, promiseTable.CONTENT, promiseTable.CREATED_TIME_MILLIS, promiseTable.UPDATED_TIME_MILLIS, QKeyComponentOracleHack.ALIAS_ID, keyComponentTable.TIMED_PROMISE_ID, keyComponentTable.KEY, keyComponentTable.VALUE};
    }

    public TimedPromiseRow getTimedPromiseRow() {
        return this.timedPromiseRow;
    }

    public Option<ComponentRow> getComponentRow() {
        return this.componentRow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimedPromiseWithComponentRow)) {
            return false;
        }
        TimedPromiseWithComponentRow that = (TimedPromiseWithComponentRow)o;
        if (this.componentRow != null ? !this.componentRow.equals(that.componentRow) : that.componentRow != null) {
            return false;
        }
        return !(this.timedPromiseRow != null ? !this.timedPromiseRow.equals(that.timedPromiseRow) : that.timedPromiseRow != null);
    }

    public int hashCode() {
        int result = this.timedPromiseRow != null ? this.timedPromiseRow.hashCode() : 0;
        result = 31 * result + (this.componentRow != null ? this.componentRow.hashCode() : 0);
        return result;
    }
}

