/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.timedpromise.internal.store.parser;

import com.atlassian.scheduler.timedpromise.api.TimedPromise;
import com.atlassian.scheduler.timedpromise.api.TimedPromiseConfig;
import com.atlassian.scheduler.timedpromise.api.TimedPromiseKey;
import com.atlassian.scheduler.timedpromise.api.TimedPromisePayload;
import com.atlassian.scheduler.timedpromise.internal.TimedPromiseImpl;
import com.atlassian.scheduler.timedpromise.internal.schema.querydsl.QKeyComponent;
import com.atlassian.scheduler.timedpromise.internal.schema.querydsl.QTimedPromise;
import com.atlassian.scheduler.timedpromise.internal.store.rows.ComponentRow;
import com.atlassian.scheduler.timedpromise.internal.store.rows.TimedPromiseRow;
import com.atlassian.scheduler.timedpromise.internal.store.rows.TimedPromiseWithComponentRow;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Maps;
import com.querydsl.core.Tuple;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class TimedPromiseParser {
    public static List<TimedPromise> parseResultStream(@Nonnull QTimedPromise timedPromiseTable, @Nonnull QKeyComponent keyComponentTable, @Nonnull List<Tuple> results) {
        Assertions.notNull((String)"results is required", results);
        Assertions.notNull((String)"keyComponentTable is required", (Object)((Object)keyComponentTable));
        Assertions.notNull((String)"timedPromiseTable is required", (Object)((Object)timedPromiseTable));
        LinkedHashMap timedPromiseRowListMap = Maps.newLinkedHashMap();
        List rows = results.stream().map(input -> TimedPromiseWithComponentRow.fromDatabase(timedPromiseTable, keyComponentTable, input)).collect(Collectors.toList());
        for (TimedPromiseWithComponentRow parsedRow : rows) {
            if (TimedPromiseParser.isNewTimedPromiseRow(parsedRow.getTimedPromiseRow(), timedPromiseRowListMap).booleanValue()) {
                TimedPromiseParser.initialiseNewTimedPromiseRow(parsedRow, timedPromiseRowListMap);
                continue;
            }
            TimedPromiseParser.addComponentToTimedPromiseRow(parsedRow, timedPromiseRowListMap);
        }
        return timedPromiseRowListMap.entrySet().stream().map(entry -> TimedPromiseParser.buildTimedPromise((TimedPromiseRow)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
    }

    public static Option<TimedPromise> parseSingleResultStream(@Nonnull QTimedPromise timedPromiseTable, @Nonnull QKeyComponent keyComponentTable, @Nonnull List<Tuple> results) {
        Assertions.notNull((String)"results is required", results);
        Assertions.notNull((String)"keyComponentTable is required", (Object)((Object)keyComponentTable));
        Assertions.notNull((String)"timedPromiseTable is required", (Object)((Object)timedPromiseTable));
        List<TimedPromise> timedPromises = TimedPromiseParser.parseResultStream(timedPromiseTable, keyComponentTable, results);
        if (timedPromises.size() > 0) {
            return Option.some((Object)timedPromises.get(0));
        }
        return Option.none();
    }

    private static Boolean isNewTimedPromiseRow(TimedPromiseRow timedPromiseRow, Map<TimedPromiseRow, List<ComponentRow>> timedPromiseRowListMap) {
        return !timedPromiseRowListMap.containsKey(timedPromiseRow);
    }

    private static void initialiseNewTimedPromiseRow(TimedPromiseWithComponentRow databaseRow, Map<TimedPromiseRow, List<ComponentRow>> resultMap) {
        ArrayList<Object> componentList = new ArrayList<Object>();
        if (databaseRow.getComponentRow().isDefined()) {
            componentList.add(databaseRow.getComponentRow().get());
        }
        resultMap.put(databaseRow.getTimedPromiseRow(), componentList);
    }

    private static void addComponentToTimedPromiseRow(TimedPromiseWithComponentRow databaseRow, Map<TimedPromiseRow, List<ComponentRow>> resultMap) {
        if (databaseRow.getComponentRow().isDefined()) {
            resultMap.get(databaseRow.getTimedPromiseRow()).add((ComponentRow)databaseRow.getComponentRow().get());
        }
    }

    private static TimedPromise buildTimedPromise(TimedPromiseRow timedPromiseRow, List<ComponentRow> componentRows) {
        String classification = timedPromiseRow.getClassification();
        String taskKey = timedPromiseRow.getTaskKey();
        long targetTimeMillis = timedPromiseRow.getTargetTimeMillis();
        TimedPromiseKey.Builder timedPromiseKeyBuilder = TimedPromiseKey.builder().classification(classification).taskRunnerKey(taskKey);
        for (ComponentRow componentRow : componentRows) {
            timedPromiseKeyBuilder.component(componentRow.getKey(), componentRow.getValue());
        }
        TimedPromiseKey timedPromiseKey = timedPromiseKeyBuilder.build();
        TimedPromiseConfig timedPromiseConfig = TimedPromiseConfig.builder().invocationTime(targetTimeMillis).payload(TimedPromiseParser.getPayload(timedPromiseRow)).build();
        return TimedPromiseImpl.builder().key(timedPromiseKey).config(timedPromiseConfig).build();
    }

    private static TimedPromisePayload getPayload(TimedPromiseRow timedPromise) {
        String content = (String)timedPromise.getContent().getOrNull();
        String mimeType = (String)timedPromise.getMimeType().getOrNull();
        if (content == null) {
            return null;
        }
        return TimedPromisePayload.builder().content(content).mimeType(mimeType).build();
    }
}

