/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.timedpromise.internal.store;

import com.atlassian.fugue.Option;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.scheduler.timedpromise.api.TimedPromise;
import com.atlassian.scheduler.timedpromise.api.TimedPromiseClassification;
import com.atlassian.scheduler.timedpromise.api.TimedPromiseKey;
import com.atlassian.scheduler.timedpromise.api.TimedPromisePayload;
import com.atlassian.scheduler.timedpromise.api.TimedPromiseSearchCriteria;
import com.atlassian.scheduler.timedpromise.api.TimedPromiseStatus;
import com.atlassian.scheduler.timedpromise.api.task.TimedPromiseTaskRunnerKey;
import com.atlassian.scheduler.timedpromise.internal.TimedPromiseKeyHasher;
import com.atlassian.scheduler.timedpromise.internal.schema.QueryDslService;
import com.atlassian.scheduler.timedpromise.internal.schema.querydsl.Tables;
import com.atlassian.scheduler.timedpromise.internal.store.TimedPromiseQueryDslDao;
import com.atlassian.scheduler.timedpromise.internal.store.parser.TimedPromiseParser;
import com.atlassian.scheduler.timedpromise.internal.store.rows.TimedPromiseWithComponentRow;
import com.atlassian.scheduler.timedpromise.spi.TimedPromiseDao;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TimedPromiseDaoImpl
extends TimedPromiseQueryDslDao
implements TimedPromiseDao {
    private final Logger LOG = LoggerFactory.getLogger(TimedPromiseDaoImpl.class);
    private final TimedPromiseKeyHasher keyHasher;
    private final long NO_EXPECTED = -1L;

    @Autowired
    public TimedPromiseDaoImpl(QueryDslService queryDslService, TimedPromiseKeyHasher keyHasher) {
        super(queryDslService);
        this.keyHasher = (TimedPromiseKeyHasher)Assertions.notNull((String)"keyHasher", (Object)keyHasher);
    }

    public TimedPromise create(@Nonnull TimedPromise timedPromise) {
        Assertions.notNull((String)"timedPromise", (Object)timedPromise);
        return this.queryDslService.runInTransaction(connection -> {
            Option<Integer> insertedIdOpt = this.insertTimedPromise(timedPromise, (DatabaseConnection)connection);
            if (insertedIdOpt.isDefined()) {
                this.insertChildComponents((Integer)insertedIdOpt.get(), timedPromise.getKey().getComponents(), (DatabaseConnection)connection);
            }
            return timedPromise;
        });
    }

    private Option<Integer> insertTimedPromise(TimedPromise timedPromise, DatabaseConnection connection) {
        Option payloadOpt = timedPromise.getPayload();
        String mimeType = null;
        String content = null;
        if (payloadOpt.isDefined()) {
            TimedPromisePayload payload = (TimedPromisePayload)payloadOpt.get();
            mimeType = (String)payload.getMimetype().getOrNull();
            content = payload.getContent();
        }
        if (this.getTimedPromiseImpl(connection, timedPromise.getKey()).isDefined()) {
            return Option.none();
        }
        long now = this.now();
        Integer tpId = (Integer)this.queryDslService.insert(connection, (RelationalPath<?>)Tables.TIMED_PROMISE).set((Path)Tables.TIMED_PROMISE.TASK_KEY, (Object)timedPromise.getKey().getTaskRunnerKey().toString()).set((Path)Tables.TIMED_PROMISE.CLASSIFICATION, (Object)timedPromise.getKey().getClassification().getName()).set((Path)Tables.TIMED_PROMISE.KEY_HASH, (Object)this.keyHasher.hash(timedPromise.getKey())).set(Tables.TIMED_PROMISE.TARGET_TIME_MILLIS, (Object)timedPromise.getScheduledInvocationTime()).set((Path)Tables.TIMED_PROMISE.STATUS, (Object)TimedPromiseStatus.SCHEDULED.getKey()).set((Path)Tables.TIMED_PROMISE.MIME_TYPE, (Object)mimeType).set((Path)Tables.TIMED_PROMISE.CONTENT, (Object)content).set(Tables.TIMED_PROMISE.CREATED_TIME_MILLIS, (Object)now).set(Tables.TIMED_PROMISE.UPDATED_TIME_MILLIS, (Object)now).executeWithKey(Tables.TIMED_PROMISE.ID);
        Option insertedIdOpt = Option.option((Object)tpId);
        if (insertedIdOpt.isEmpty()) {
            throw new RuntimeException("Failed to retrieve Timed Promise row after insertion");
        }
        return insertedIdOpt;
    }

    private void insertChildComponents(int parentId, TimedPromiseKey.Components components, DatabaseConnection connection) {
        for (String key : components.listKeys()) {
            long rowsInserted = this.queryDslService.insert(connection, (RelationalPath<?>)Tables.KEY_COMPONENT).set(Tables.KEY_COMPONENT.TIMED_PROMISE_ID, (Object)parentId).set((Path)Tables.KEY_COMPONENT.KEY, (Object)key).set((Path)Tables.KEY_COMPONENT.VALUE, components.get(key).getOrNull()).execute();
            if (rowsInserted == 1L) continue;
            throw new RuntimeException("Expected 1 inserted component, but received " + rowsInserted);
        }
    }

    public Option<TimedPromise> get(@Nonnull TimedPromiseKey timedPromiseKey) {
        Assertions.notNull((String)"timedPromiseKey", (Object)timedPromiseKey);
        return this.queryDslService.run(connection -> this.getTimedPromiseImpl((DatabaseConnection)connection, timedPromiseKey));
    }

    public Option<TimedPromise> getTimedPromiseImpl(@Nonnull DatabaseConnection connection, @Nonnull TimedPromiseKey timedPromiseKey) {
        Assertions.notNull((String)"timedPromiseKey", (Object)timedPromiseKey);
        List tuples = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(TimedPromiseWithComponentRow.getColumns(Tables.TIMED_PROMISE, Tables.KEY_COMPONENT)).from((Expression)Tables.TIMED_PROMISE)).leftJoin((EntityPath)Tables.KEY_COMPONENT)).on((Predicate)Tables.TIMED_PROMISE.ID.eq(Tables.KEY_COMPONENT.TIMED_PROMISE_ID))).where((Predicate)Tables.TIMED_PROMISE.KEY_HASH.eq((Object)this.keyHasher.hash(timedPromiseKey)))).fetch();
        return StepsConverters.olderOption(TimedPromiseParser.parseSingleResultStream(Tables.TIMED_PROMISE, Tables.KEY_COMPONENT, tuples));
    }

    public Option<TimedPromise> getNextScheduled() {
        List justOne = this.queryDslService.run(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(TimedPromiseWithComponentRow.getColumns(Tables.TIMED_PROMISE, Tables.KEY_COMPONENT)).from((Expression)Tables.TIMED_PROMISE)).leftJoin((EntityPath)Tables.KEY_COMPONENT)).on((Predicate)Tables.TIMED_PROMISE.ID.eq(Tables.KEY_COMPONENT.TIMED_PROMISE_ID))).where((Predicate)Tables.TIMED_PROMISE.STATUS.eq((Object)TimedPromiseStatus.SCHEDULED.getKey()))).orderBy(Tables.TIMED_PROMISE.TARGET_TIME_MILLIS.asc())).orderBy(Tables.TIMED_PROMISE.ID.asc())).limit(1L)).fetch());
        return StepsConverters.olderOption(TimedPromiseParser.parseSingleResultStream(Tables.TIMED_PROMISE, Tables.KEY_COMPONENT, justOne));
    }

    public Option<TimedPromiseStatus> getStatus(@Nonnull TimedPromiseKey timedPromiseKey) {
        Assertions.notNull((String)"timedPromiseKey", (Object)timedPromiseKey);
        return this.queryDslService.run(connection -> {
            Option result = Option.option((Object)((SQLQuery)((SQLQuery)connection.select((Expression)Tables.TIMED_PROMISE.STATUS).from((Expression)Tables.TIMED_PROMISE)).where((Predicate)Tables.TIMED_PROMISE.KEY_HASH.eq((Object)this.keyHasher.hash(timedPromiseKey)))).fetchOne());
            return result.map(TimedPromiseStatus::forKey);
        });
    }

    public Option<TimedPromise> update(@Nonnull TimedPromise timedPromise) {
        Assertions.notNull((String)"timedPromise", (Object)timedPromise);
        if (!this.exists(timedPromise.getKey())) {
            return Option.none();
        }
        return this.queryDslService.update((RelationalPath<?>)Tables.TIMED_PROMISE, update -> {
            long rowsUpdated;
            update.where((Predicate)Tables.TIMED_PROMISE.KEY_HASH.eq((Object)this.keyHasher.hash(timedPromise.getKey()))).set(Tables.TIMED_PROMISE.TARGET_TIME_MILLIS, (Object)timedPromise.getScheduledInvocationTime()).set(Tables.TIMED_PROMISE.UPDATED_TIME_MILLIS, (Object)this.now());
            Option payloadOpt = timedPromise.getPayload();
            if (payloadOpt.isDefined()) {
                TimedPromisePayload payload = (TimedPromisePayload)payloadOpt.get();
                update.set((Path)Tables.TIMED_PROMISE.MIME_TYPE, payload.getMimetype().getOrNull()).set((Path)Tables.TIMED_PROMISE.CONTENT, (Object)payload.getContent());
            }
            if ((rowsUpdated = update.execute()) != 1L) {
                throw new RuntimeException("Expected 1 updated row, but received " + rowsUpdated);
            }
            return Option.some((Object)timedPromise);
        });
    }

    private boolean exists(TimedPromiseKey timedPromiseKey) {
        return this.get(timedPromiseKey).isDefined();
    }

    public boolean updateStatus(@Nonnull TimedPromiseKey timedPromiseKey, @Nonnull TimedPromiseStatus newStatus) {
        Assertions.notNull((String)"timedPromiseKey", (Object)timedPromiseKey);
        Assertions.notNull((String)"newStatus", (Object)newStatus);
        if (!this.exists(timedPromiseKey)) {
            return false;
        }
        return this.queryDslService.update((RelationalPath<?>)Tables.TIMED_PROMISE, update -> {
            update.where((Predicate)Tables.TIMED_PROMISE.KEY_HASH.eq((Object)this.keyHasher.hash(timedPromiseKey))).set((Path)Tables.TIMED_PROMISE.STATUS, (Object)newStatus.getKey()).set(Tables.TIMED_PROMISE.UPDATED_TIME_MILLIS, (Object)this.now());
            long rowsUpdated = update.execute();
            if (rowsUpdated != 1L) {
                throw new RuntimeException("Expected 1 updated row, but received " + rowsUpdated);
            }
            return Boolean.TRUE;
        });
    }

    public long updateStatuses(@Nonnull List<TimedPromiseKey> timedPromiseKeys, @Nonnull TimedPromiseStatus newStatus) {
        Assertions.notNull((String)"timedPromiseKeys", timedPromiseKeys);
        Assertions.notNull((String)"newStatus", (Object)newStatus);
        if (timedPromiseKeys.isEmpty()) {
            return 0L;
        }
        List<String> timedPromiseKeyHashes = this.hashMultiple(timedPromiseKeys);
        return this.queryDslService.update((RelationalPath<?>)Tables.TIMED_PROMISE, update -> {
            update.where((Predicate)Tables.TIMED_PROMISE.KEY_HASH.in((Collection)timedPromiseKeyHashes)).set((Path)Tables.TIMED_PROMISE.STATUS, (Object)newStatus.getKey()).set(Tables.TIMED_PROMISE.UPDATED_TIME_MILLIS, (Object)this.now());
            return update.execute();
        });
    }

    public long updateStatuses(@Nonnull List<TimedPromiseKey> timedPromiseKeys, @Nonnull TimedPromiseStatus newStatus, @Nonnull TimedPromiseStatus currentStatus) {
        Assertions.notNull((String)"timedPromiseKeys", timedPromiseKeys);
        Assertions.notNull((String)"newStatus", (Object)newStatus);
        Assertions.notNull((String)"currentStatus", (Object)currentStatus);
        if (timedPromiseKeys.isEmpty()) {
            return 0L;
        }
        List<String> timedPromiseKeyHashes = this.hashMultiple(timedPromiseKeys);
        return this.queryDslService.update((RelationalPath<?>)Tables.TIMED_PROMISE, update -> {
            update.where((Predicate)Tables.TIMED_PROMISE.KEY_HASH.in((Collection)timedPromiseKeyHashes).and((Predicate)Tables.TIMED_PROMISE.STATUS.eq((Object)currentStatus.getKey()))).set((Path)Tables.TIMED_PROMISE.STATUS, (Object)newStatus.getKey()).set(Tables.TIMED_PROMISE.UPDATED_TIME_MILLIS, (Object)this.now());
            return update.execute();
        });
    }

    public boolean delete(@Nonnull TimedPromiseKey timedPromiseKey) {
        Assertions.notNull((String)"timedPromiseKey", (Object)timedPromiseKey);
        Option<TimedPromise> existingTimedPromise = this.get(timedPromiseKey);
        if (existingTimedPromise.isEmpty()) {
            return false;
        }
        BooleanExpression equalsHash = Tables.TIMED_PROMISE.KEY_HASH.eq((Object)this.keyHasher.hash(timedPromiseKey));
        this.deleteTimedPromisesWhere((Predicate)equalsHash, 1L, this.getComponentCount(timedPromiseKey));
        return true;
    }

    public long deleteMultiple(@Nonnull List<TimedPromiseKey> timedPromiseKeys) {
        Assertions.notNull((String)"timedPromiseKeys", timedPromiseKeys);
        if (timedPromiseKeys.isEmpty()) {
            return 0L;
        }
        List<String> timedPromiseKeyHashes = this.hashMultiple(timedPromiseKeys);
        BooleanExpression inKeyHashes = Tables.TIMED_PROMISE.KEY_HASH.in(timedPromiseKeyHashes);
        return this.deleteTimedPromisesWhere((Predicate)inKeyHashes, timedPromiseKeys.size(), this.countComponents(timedPromiseKeys));
    }

    private int countComponents(List<TimedPromiseKey> timedPromiseKeys) {
        int componentCount = 0;
        for (TimedPromiseKey timedPromiseKey : timedPromiseKeys) {
            componentCount += this.getComponentCount(timedPromiseKey);
        }
        return componentCount;
    }

    private int getComponentCount(TimedPromiseKey timedPromiseKey) {
        return Lists.newArrayList((Iterable)timedPromiseKey.getComponents().listKeys()).size();
    }

    public List<TimedPromise> deleteOlderThan(long duration, TimeUnit unit) {
        Duration cutoffDuration = Duration.millis((long)TimeUnit.MILLISECONDS.convert(duration, unit));
        long cutoffTime = DateTime.now().minus((ReadableDuration)cutoffDuration).getMillis();
        BooleanExpression olderThanCutoffTime = Tables.TIMED_PROMISE.TARGET_TIME_MILLIS.lt((Number)cutoffTime);
        List<TimedPromise> deletedTimedPromises = this.getTimedPromiseWhere((Predicate)olderThanCutoffTime);
        this.deleteTimedPromisesWhere((Predicate)olderThanCutoffTime, -1L, -1L);
        return deletedTimedPromises;
    }

    private long deleteTimedPromisesWhere(Predicate whereClause, long timedPromisesExpected, long componentsExpected) {
        SQLQuery sqlSubQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(Tables.KEY_COMPONENT.ID).from((Expression)Tables.TIMED_PROMISE)).leftJoin((EntityPath)Tables.KEY_COMPONENT)).on((Predicate)Tables.TIMED_PROMISE.ID.eq(Tables.KEY_COMPONENT.TIMED_PROMISE_ID))).where(whereClause);
        SQLQuery<Integer> aliasedSqlSubQuery = this.createCompatibleSubQueryForInteger((SQLQuery<Integer>)sqlSubQuery, "ID", "ALIASED_KEY_COMPONENT");
        long componentsDeleted = this.deleteWhere((RelationalPathBase<?>)Tables.KEY_COMPONENT, (Predicate)Tables.KEY_COMPONENT.ID.in(aliasedSqlSubQuery));
        if (componentsExpected >= 0L && componentsExpected != componentsDeleted) {
            this.LOG.warn("Expected {} deleted Component row(s), but received {}", (Object)componentsExpected, (Object)componentsDeleted);
        }
        long timedPromisesDeleted = this.deleteWhere((RelationalPathBase<?>)Tables.TIMED_PROMISE, whereClause);
        if (timedPromisesExpected >= 0L && timedPromisesDeleted != timedPromisesExpected) {
            this.LOG.warn("Expected {} deleted Timed Promise row(s), but received {}", (Object)timedPromisesExpected, (Object)timedPromisesDeleted);
        }
        return timedPromisesDeleted;
    }

    public List<TimedPromise> findScheduled(@Nonnull TimedPromiseSearchCriteria timedPromiseSearchCriteria) {
        Assertions.notNull((String)"timedPromiseSearchCriteria", (Object)timedPromiseSearchCriteria);
        List<TimedPromise> findResults = this.getFindResults(timedPromiseSearchCriteria);
        ArrayList filteredResults = Lists.newArrayList();
        for (TimedPromise timedPromise : findResults) {
            if (!this.timedPromiseContainsAllComponentsInCriteria(timedPromise, timedPromiseSearchCriteria)) continue;
            filteredResults.add(timedPromise);
        }
        return filteredResults;
    }

    private boolean timedPromiseContainsAllComponentsInCriteria(TimedPromise timedPromise, TimedPromiseSearchCriteria timedPromiseSearchCriteria) {
        for (String key : timedPromiseSearchCriteria.getComponents().listKeys()) {
            Option value = timedPromise.getKey().getComponents().get(key);
            if (timedPromiseSearchCriteria.getComponents().get(key).equals((Object)value)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private List<TimedPromise> getFindResults(TimedPromiseSearchCriteria timedPromiseSearchCriteria) {
        List tuples = this.queryDslService.run(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(TimedPromiseWithComponentRow.getColumns(Tables.TIMED_PROMISE, Tables.KEY_COMPONENT)).from((Expression)Tables.TIMED_PROMISE)).leftJoin((EntityPath)Tables.KEY_COMPONENT)).on((Predicate)Tables.TIMED_PROMISE.ID.eq(Tables.KEY_COMPONENT.TIMED_PROMISE_ID))).where(this.buildFindWhereClause(timedPromiseSearchCriteria))).orderBy(Tables.TIMED_PROMISE.TARGET_TIME_MILLIS.desc())).orderBy(Tables.TIMED_PROMISE.ID.desc())).fetch());
        return TimedPromiseParser.parseResultStream(Tables.TIMED_PROMISE, Tables.KEY_COMPONENT, tuples);
    }

    private Predicate buildFindWhereClause(TimedPromiseSearchCriteria searchCriteria) {
        BooleanExpression whereClause = Tables.TIMED_PROMISE.STATUS.ne((Object)TimedPromiseStatus.RUNNING.getKey());
        if (searchCriteria.getTaskRunnerKey().isDefined()) {
            whereClause = whereClause.and((Predicate)Tables.TIMED_PROMISE.TASK_KEY.eq((Object)((TimedPromiseTaskRunnerKey)searchCriteria.getTaskRunnerKey().get()).toString()));
        }
        if (searchCriteria.getClassification().isDefined()) {
            whereClause = whereClause.and((Predicate)Tables.TIMED_PROMISE.CLASSIFICATION.eq((Object)((TimedPromiseClassification)searchCriteria.getClassification().get()).getName()));
        }
        return whereClause;
    }

    public List<TimedPromise> getReadyToBeExecuted() {
        BooleanExpression readyToBeExecuted = Tables.TIMED_PROMISE.STATUS.eq((Object)TimedPromiseStatus.SCHEDULED.getKey()).and((Predicate)Tables.TIMED_PROMISE.TARGET_TIME_MILLIS.loe((Number)this.now()));
        return this.getTimedPromiseWhere((Predicate)readyToBeExecuted);
    }

    public List<TimedPromise> getRunning() {
        BooleanExpression inRunningStatus = Tables.TIMED_PROMISE.STATUS.eq((Object)TimedPromiseStatus.RUNNING.getKey());
        return this.getTimedPromiseWhere((Predicate)inRunningStatus);
    }

    public List<TimedPromise> getWaiting(@Nonnull TimedPromiseTaskRunnerKey key) {
        Assertions.notNull((String)"key", (Object)key);
        BooleanExpression waitingForTaskAvailability = Tables.TIMED_PROMISE.STATUS.eq((Object)TimedPromiseStatus.WAITING_ON_TASK_AVAILABILITY.getKey()).and((Predicate)Tables.TIMED_PROMISE.TARGET_TIME_MILLIS.loe((Number)this.now())).and((Predicate)Tables.TIMED_PROMISE.TASK_KEY.eq((Object)key.toString()));
        return this.getTimedPromiseWhere((Predicate)waitingForTaskAvailability);
    }

    private List<TimedPromise> getTimedPromiseWhere(Predicate whereClause) {
        List resultStream = this.queryDslService.run(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(TimedPromiseWithComponentRow.getColumns(Tables.TIMED_PROMISE, Tables.KEY_COMPONENT)).from((Expression)Tables.TIMED_PROMISE)).leftJoin((EntityPath)Tables.KEY_COMPONENT)).on((Predicate)Tables.TIMED_PROMISE.ID.eq(Tables.KEY_COMPONENT.TIMED_PROMISE_ID))).where(whereClause)).orderBy(Tables.TIMED_PROMISE.TARGET_TIME_MILLIS.asc())).orderBy(Tables.TIMED_PROMISE.ID.asc())).fetch());
        return TimedPromiseParser.parseResultStream(Tables.TIMED_PROMISE, Tables.KEY_COMPONENT, resultStream);
    }

    private List<String> hashMultiple(List<TimedPromiseKey> timedPromiseKeys) {
        ArrayList timedPromiseKeyHashes = Lists.newArrayList();
        timedPromiseKeyHashes.addAll(timedPromiseKeys.stream().map(arg_0 -> ((TimedPromiseKeyHasher)this.keyHasher).hash(arg_0)).collect(Collectors.toList()));
        return timedPromiseKeyHashes;
    }

    private long now() {
        return DateTimeUtils.currentTimeMillis();
    }
}

