/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.timedpromise.internal.schema;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.util.concurrent.Assertions;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryDslService {
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public QueryDslService(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = (DatabaseAccessor)Assertions.notNull((String)"databaseAccessor", (Object)databaseAccessor);
    }

    public <T> T runInTransaction(@Nonnull Function<DatabaseConnection, T> callback) {
        return (T)this.databaseAccessor.runInTransaction(callback);
    }

    public <T> T run(@Nonnull Function<DatabaseConnection, T> callback) {
        return (T)this.databaseAccessor.run(callback);
    }

    public SQLInsertClause insert(DatabaseConnection connection, RelationalPath<?> table) {
        return connection.insert(table);
    }

    public <T> T update(RelationalPath<?> table, Function<SQLUpdateClause, T> function) {
        return (T)this.databaseAccessor.run(connection -> function.apply(connection.update(table)));
    }

    public <T> T delete(RelationalPath<?> table, Function<SQLDeleteClause, T> function) {
        return (T)this.databaseAccessor.run(connection -> function.apply(connection.delete(table)));
    }
}

