/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.timedpromise.internal.history.store.rows;

import com.atlassian.scheduler.timedpromise.internal.schema.querydsl.QHistoryRecord;
import com.atlassian.util.concurrent.Assertions;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TimedPromiseHistoryRecordRow {
    private final long id;
    private final String hash;
    private final String eventType;
    private final long eventTimeMillis;
    private final String message;
    private final long targetTimeMillis;

    private TimedPromiseHistoryRecordRow(Integer id, String hash, String eventType, @Nullable Long eventTimeMillis, String message, @Nullable Long targetTimeMillis) {
        this.id = ((Integer)Assertions.notNull((String)"id", (Object)id)).intValue();
        this.hash = (String)Assertions.notNull((String)"hash", (Object)hash);
        this.eventType = (String)Assertions.notNull((String)"eventType", (Object)eventType);
        this.eventTimeMillis = (Long)Option.option((Object)eventTimeMillis).getOrElse((Object)0L);
        this.message = (String)Assertions.notNull((String)"message", (Object)message);
        this.targetTimeMillis = (Long)Option.option((Object)targetTimeMillis).getOrElse((Object)0L);
    }

    public static TimedPromiseHistoryRecordRow fromDatabase(@Nonnull QHistoryRecord historyRecord, @Nonnull Tuple row) {
        Assertions.notNull((String)"row is required", (Object)row);
        Assertions.notNull((String)"historyRecord is required", (Object)((Object)historyRecord));
        return new TimedPromiseHistoryRecordRow((Integer)row.get(historyRecord.ID), (String)row.get((Expression)historyRecord.TIMED_PROMISE_HISTORY_KEY_HASH), (String)row.get((Expression)historyRecord.EVENT_TYPE), (Long)row.get(historyRecord.EVENT_TIME_MILLIS), (String)row.get((Expression)historyRecord.MESSAGE), (Long)row.get(historyRecord.TARGET_TIME_MILLIS));
    }

    public static Path<?>[] getColumns(@Nonnull QHistoryRecord historyRecord) {
        Assertions.notNull((String)"historyRecord is required", (Object)((Object)historyRecord));
        return new Path[]{historyRecord.ID, historyRecord.TIMED_PROMISE_HISTORY_KEY_HASH, historyRecord.EVENT_TYPE, historyRecord.EVENT_TIME_MILLIS, historyRecord.MESSAGE, historyRecord.TARGET_TIME_MILLIS};
    }

    public long getId() {
        return this.id;
    }

    public String getHash() {
        return this.hash;
    }

    public String getEventType() {
        return this.eventType;
    }

    public long getEventTimeMillis() {
        return this.eventTimeMillis;
    }

    public String getMessage() {
        return this.message;
    }

    public long getTargetTimeMillis() {
        return this.targetTimeMillis;
    }
}

