/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.chaperone.rest;

import com.atlassian.chaperone.ChaperonePinManager;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;

@Path(value="chaperone")
public class ChaperoneResource {
    private static final CacheControl NO_CACHE = ChaperoneResource.getNoCache();
    private ChaperonePinManager pinManager;

    public ChaperoneResource(ChaperonePinManager pinManager) {
        this.pinManager = pinManager;
    }

    @GET
    @Path(value="{key}")
    @Produces(value={"application/json"})
    public Response getPins(@PathParam(value="key") String key) {
        return Response.ok((Object)this.pinManager.getValue(key)).cacheControl(NO_CACHE).build();
    }

    @PUT
    @Path(value="{key}")
    @Produces(value={"application/json"})
    public Response putPins(@PathParam(value="key") String key, @FormParam(value="json") String json) {
        this.pinManager.setValue(key, json);
        return Response.ok().cacheControl(NO_CACHE).build();
    }

    private static CacheControl getNoCache() {
        CacheControl cc = new CacheControl();
        cc.setNoCache(true);
        return cc;
    }
}

