require([
	'../aloha/src/aloha',
	'../aloha/src/editables',
	'../aloha/src/arrays',
	'../aloha/src/typing',
	'../aloha/src/keys',
	'../aloha/src/maps',
	'../aloha/src/undo',
	'../aloha/src/ranges',
	'../aloha/src/dom',
	'../aloha/tests/crazy-slots/crazy-slots'
], function (
	Aloha,
	Editables,
	Arrays,
	Typing,
	Keys,
	Maps,
	Undo,
	Ranges,
	Dom,
	CrazySlots
) {
	'use strict';

	function parseQueryString(url) {
		var matches = url.match(/\?(.*)$/);
		if (!matches) {
			return {};
		}
		var queryStr = matches[1];
		var nameValue = queryStr.split('&');
		var vars = {};
		for (var i = 0; i < nameValue.length; i++) {
			var pair = nameValue[i].split('=');
			vars[window.decodeURIComponent(pair[0])] = pair[1] && window.decodeURIComponent(pair[1]);
		}
		return vars;
	}

	function run(elem) {
		var editor = {
			settings: {
				defaultBlockNodeName: 'div'
			},
			overrides: [],
			editables: {}
		};
		var editable = Editables.Editable(elem);
		editable.overrides = [];
		editable.settings = {
			defaultBlockNodeName: 'div'
		};
		Editables.assocIntoEditor(editor, editable);
		var mutations = [
			{
				probability: 5,
				deletesRange: true,
				mutate: function (elem, range) {
					var texts = ['Lorem', 'ipsum', 'dolor', 'sit', 'amet,', 'quodsi', 'deleniti', 'per', 'at,',
					             'pro', 'aperiam', 'dissentiet', 'ad.', 'Hinc', 'nominati',
					             'pri', 'no,', 'et',
					             'vix', 'tacimates', 'maluisset', 'adversarium.', 'Et',
					             'mea', 'etiam', 'legendos,',
					             'posse', 'graeco', 'bonorum', 'per', 'in.',
					             'Dicant', 'insolens', 'iracundia', 'ne', 'vis,', 'in',
					             'eligendi', 'iudicabit', 'vis.'];
					
					var text = texts[CrazySlots.randomInt(0, texts.length - 1)];
					if (CrazySlots.randomInt(0, 20) !== 0) {
						Ranges.collapseToStart(range);
					}
					Undo.capture(editable.undoContext, {meta: 'typing'}, function () {
						Typing.actions.inputText.mutate({
							editable: editable,
							range: range,
							chr: text
						});
					});
				}
			}
		];
		function updateStyle(alohaEvent) {
			var valuesByName = {'color': ['red', 'green', 'blue'],
			                    'background-color': ['red', 'green', 'blue'],
			                    'padding-left': [5, 10]};
			var elem = alohaEvent.editable.elem;
			var elems = elem.getElementsByTagName('*');
			if (!elems.length) {
				return;
			}
			Maps.forEach(valuesByName, function (values, name) {
				var elemToUpdate = elems[CrazySlots.randomInt(0, elems.length - 1)];
				var value = values[CrazySlots.randomInt(0, values.length - 1)];
				elemToUpdate.style[name] = value;
			});
		}
		function updateAttribute(alohaEvent) {
			var valuesByName = {'name': ['one', 'two', 'three'],
			                    'lang': ['en', 'es', 'kr'],
			                    'href': ['http://one.com', 'https://two.com']};
			var elem = alohaEvent.editable.elem;
			var elems = elem.getElementsByTagName('*');
			if (!elems.length) {
				return;
			}
			Maps.forEach(valuesByName, function (values, name) {
				var elemToUpdate = elems[CrazySlots.randomInt(0, elems.length - 1)];
				var value = values[CrazySlots.randomInt(0, values.length - 1)];
				elemToUpdate.setAttribute(name, value);
			});
		}
		function mutationFromAction(action) {
			return function (elem, range) {
				if (action.undo) {
					Undo.capture(editable.undoContext, {meta: action.undo}, function () {
						action.mutate({editable: editable, range:  range});
					});
				} else {
					action.mutate({editable: editable, range: range});
				}
			};
		}
		var simpleMutations = [
			{
				deletesRange: true,
				mutate: mutationFromAction(Typing.actions.deleteBackward)
			},
			{
				deletesRange: true,
				mutate: mutationFromAction(Typing.actions.deleteForward)
			},
			{
				deletesRange: true,
				endOfLineProbability: 4,
				mutate: mutationFromAction(Typing.actions.breakBlock)
			},
			{
				deletesRange: true,
				endOfLineProbability: 4,
				mutate: mutationFromAction(Typing.actions.breakLine)
			},
			{
				deletesRange: false,
				mutate: mutationFromAction(Typing.actions.formatBold)
			},
			{
				deletesRange: false,
				mutate: mutationFromAction(Typing.actions.formatItalic)
			},
			{
				deletesRange: false,
				mutate: mutationFromAction(Typing.actions.undo)
			},
			{
				deletesRange: false,
				mutate: mutationFromAction(Typing.actions.redo)
			},
			{
				deletesRange: false,
				mutate: mutationFromAction({mutate: updateAttribute})
			},
			{
				deletesRange: false,
				mutate: mutationFromAction({mutate: updateStyle})
			}
		];
		mutations = mutations.concat(simpleMutations);

		var params = parseQueryString(window.location.href);
		Aloha.aloha(editable.elem);
		if (params['readOnly'])return;

		CrazySlots.run(editable, mutations, {
			continueOnError: true,
			log: true,
			wait: params['wait'] || 100
		});
	}

	function main() {
		Arrays.coerce([$('iframe')[0].contentDocument.body]).forEach(function (editable) {
			run(editable);
		});
	}

	main()
});
