Synchrony
====

## Setup

### Development

#### Installing Dev Dependencies

##### Java Cryptography Extension (JCE)

Synchrony requires support for unlimited strength jurisdiction policy files for its encryption solution. This means we require the JCE to be installed on your machine.

1. Download the JCE package from [here](http://www.oracle.com/technetwork/java/javase/downloads/jce8-download-2133166.html). Note: Make sure that you download the JCE that matches your version of the JDK.

2. Unzip the JCE package and move the two .jar files to the security folder of your JDK installation. On OSX this is found at:

        /Library/Java/JavaVirtualMachines/jdk[YOUR_JDK_VERSION].jdk/Contents/Home/jre/lib/security/

    Alternatively, if you are not on OSX, you can run the following command to find the directory:

        sudo find / -name US_export_policy.jar

##### NodeJS & NPM

You can install this through a package manager such as [Homebrew](http://brew.sh) or by following the instructions at the [nodejs website](https://nodejs.org/en/).

##### Leiningen

Leiningen is a build tool for Clojure projects.

1. Install Leiningen by following the instructions at [leiningen.org](http://leiningen.org)

2. Roll back the Leiningen version to 2.4.3 until [this bug](https://github.com/technomancy/leiningen/issues/1718) gets fixed.

        lein upgrade 2.4.3

#### Installing Project Dependencies

1. Fetch npm dependencies,

        npm install
    

2. Ensure submodules are initialized,

        git submodule update --init
    

3. Ensure the ginga artifact is installed,

        (cd checkouts/ginga; lein install)
    

4. Copy over our default environment variables (you need to do this again later with updated db details),

        cp lein-env.example .lein-env
    
    
5. FOR LOCAL DEVELOPMENT OF COLLABORATIVE EDITOR PLUGIN ONLY - Disable the auth token check by deleting the following line from .lein-env,

        :feature-auth-token "true"
    

#### Optional - Install gaffer

[gaffer](https://github.com/jingweno/gaffer) is a JVM tool that allows multiple processes to be started simultaneously and provides colour-coded output. It will be explained later in this document.

To install it on Mac using homebrew:

```
$ brew tap jingweno/gaffer
$ brew install gaffer
```


### Running the server in the REPL

Once the dev and project dependencies are installed it should be possible to start up a server by firing up a repl, loading the
src-dev/synchrony_repl.clj namespace, and evaluating `(reset)` (this uses an in-memory store implementation):

    lein repl
    synchrony.core=> (require '[synchrony-repl :refer [reset]])
    synchrony.core=> (reset)
    ;; #<SystemMap>


### Building

build it for development (or replace dev with prod to get a minified js
file),

    ./node_modules/.bin/gulp build:dev

build the closure files again (TODO: should have been done by build:dev
but there seems to be some kind of race condition).

    ./node_modules/.bin/gulp closurify


### Running the app outside the REPL

We support DynamoDB (used in production) and PostgreSQL (legacy and BTF). Here's how to setup both:

#### PostgreSQL 

Installing PostgreSQL:
 
    brew install postgres
 
Once installed, create a database called `wikidocs` and execute the sql script found in `./dev-resources/schema.sql`.

#### DynamoDB 

Installing DynamoDB:

    brew install dynamodb-local

 Run DynamoDB:

    dynamodb-local

 Once you have it running you need to create the DynamoDB schema:
 
    lein dynamodb:setup
    
> Conversely, dynamodb:teardown drops the schema

Next, create your own env file from the provided example (and update the postgres db connection details in it):

    cp lein-env.example .lein-env
    
Finally, run it:

    lein run </dev/null &  ;; this will start the AWS system using the locally installed DynamoDB
    ;; or
    lein run sql </dev/null &  ;; this will start the QueryDSL system using the database url specified in the configuration to connect to PostgreSQL
    
    


or build an uberjar/osgi module (besides build:standalone there is also available: build:confluence-plugin for the experimental confluence OSGI plugin uberjar, and build:micros for the uberjar we deploy to micros)

    ./node_modules/.bin/gulp build:standalone

the result will be in target/synchrony-*-standalone.jar.

You can also let gulp/leiningen watch for changes and recompile
everything automatically

    ./node_modules/.bin/gulp watch:js
    lein watch</dev/null&


Alternatively, user *gaffer* to start all needed processes for development (ensure PostgreSQL is running first):

    gaffer start -f Procfile.dev

### The Interactive test page

Once you start the server (either from the repl or with `lein run`) you
should be able to access `http://$REZA_HOST:$REZA_PORT/resources/tests/interactive.html`


## Running the tests

### Clojure JVM tests

From the command line:

    lein test

    
## We make use of property-based tests - a.k.a. generative tests - and some of them can be slow. The default test task doesn't include slow tests. To run these slow tests, use:

    lein test :slow
    
By default this will run 100 tests per `test.check` property. This can be changed like so:

    TEST_CHECK_TEST_COUNT=500 lein test :slow

Have a look at the testing guidelines [here](https://pug.jira-dev.com/wiki/display/WD/Testing+guidelines) for information on writing tests and tagging them as `:slow`



### Client-side Tests (Javascript)

The client-side JavaScript tests can be run in one of two ways,

From the command line:

    ./node_modules/.bin/gulp test:js
    
Or from the browser (make sure the server is running first) by visiting `http://$REZA_HOST:$REZA_PORT/tests/index.html`

   
### Client-side Tests (Clojurescript)

From the command line:

    ./node_modules/gulp/bin/gulp.js test:cljs
    
During development, it's useful to auto-reload and run tests when tests or source files change. To do so, first watch the source files so they get compiled to javascript:

    lein watch-cljs-tests

Next, start the test runner (karma) in watch mode:

    ./node_modules/gulp/bin/gulp.js test:cljs:watch
    
By default karma will run the tests using karma.


Alternatively, user *gaffer* to start all needed processes for auto-running the Clojurescript tests:

    gaffer start -f Procfile.cljs-tests

### Running all tests

Bamboo uses this task but it can be useful to run it locally before checking in in order to make sure all three types of tests are green:


   ./bin/build test


### Version numbers

Version numbers in branches other than `master` should end in the branch name to avoid confusion. For example:

    0.1.3-dev
    
All versions built in `master` should drop the suffix as these are releasable builds:

    0.1.3

### Microservice deployment

Use the [Bamboo build plan](https://collaboration-bamboo.internal.atlassian.com/browse/WD-RELEASE) to automatically build, push to S3 and deploy to micros. In case you want to deploy manually you need to install micros https://extranet.atlassian.com/display/MICROS/Getting+Started
    
    gulp build:micros
    // upload to S3 atl-builds/wikidocs
    MICROS_TOKEN=<TOKEN> micros service:deploy wikidocs -f profile-resources/micros/service-descriptor.json -v -e adev

With the above manual deployment the Service will run on

    synchrony.app.dev.atlassian.io

### Database (only required for `lein run`)

To set up a database for persistence - we assume a postgres instance runs on
localhost and the user and schema are "wikidocs" - create the schema,

    psql -U wikidocs -h localhost wikidocs < dev-resources/schema.sql

### Configuration (only required for `lein run`)

In order to run from the command line (as opposed to from the repl or as
a osgi plugin) customize the example configuration,

    cp lein-env.example .lein-env

and at least change the following:

    :reza-database-url ... your database settings ...
    
### MICROS Environments

Currently Synchrony runs on 5 environments:

    wikidocs.domain.dev.atlassian.io      ;; dev and least stable environment
    wikidocs.app.dev.atlassian.io         ;; when we're getting ready to a new release
    wikidocs.uswest.staging.atlassian.io  ;; where we deploy release candidates that should not have regressions
    wikidocs.east.staging.atlassian.io    ;; used for load testing / investigation / debugging
    wikidocs.uswest.atlassian.io          ;; production
    
All these URLs are accessible as synchrony.* - the wikidocs service name is a legacy fact. The sycnhrony CNAME alias was created for each environment using this command:

    micros route:update -t CNAME useast.staging.atlassian.io synchrony wikidocs.useast.staging.atlassian.io. -e stg-east
    
More info [here](https://extranet.atlassian.com/display/MICROS/How-to:+Use+custom+domain+names+with+MICROS)    
    
When first creating and deploying to these environments, certain environment variables need to be set manually. They are:

    micros stash:set SOCKJS_LIBRARY_URL "https://synchrony.domain.dev.atlassian.io/js/vendor/sockjs.min.js" -e ddev -s wikidocs
    micros stash:set OPENID_PROVIDER    "https://id.atlassian.com/openid/v2/op"                -e ddev -s wikidocs
    micros stash:set OPENID_RETURN_URI  "https://synchrony.domain.dev.atlassian.io/openid-return"           -e ddev -s wikidocs
    micros stash:set OPENID_REALM       "https://*.atlassian.io"                                            -e ddev -s wikidocs
    
The environment identifier given to the `-e` flag corresponds to the environments above and can be one of ddev, adev, stg-west and prod-west respectively.


