/*
 * Loads the configuration from the backend
 */
function loadConfig() {
  log.debug("Loading configuration data");
  disableForm();
  AJS.$.ajax({
    url: baseUrl + "/rest/samlsso-admin/1.0/",
    dataType: "json",
    success: function(config) {
      configurationObject = config;  // Replace the global configuration object
      fillFields();
      
      AJS.$("#licenseMessage").text(config.licenseMessage);
      if(config.licensed) {
        AJS.$("#licenseMessage").removeClass("error");
        AJS.$("#licenseMessage").addClass("success");
      } else {
        AJS.$("#licenseMessage").addClass("error");
        AJS.$("#licenseMessage").removeClass("success");      
      }
      enableForm();
    },
    error: function() {
      AJS.$("#aui-message-bar").empty(); 
      AJS.messages.error({
        title: "Load failed",
        body: "Loading settings failed!",
        closeable: false
      });
      enableForm();
    }
  });
}

/*
 * Gathers the configuration data from the form fields and sends them to the backend
 */
function updateConfig() {
  disableForm();
  readFields();

  AJS.$.ajax({
    url: baseUrl + "/rest/samlsso-admin/1.0/",
    type: "PUT",
    contentType: "application/json; charset=utf-8",
    data: JSON.stringify(configurationObject),
    dataType: "json",
    processData: true,
    success: function (data) { 
      if(data.ok) {
        setMessage(true, 'Save successful', data.messages);
      } else {
        setMessage(false, 'Save failed', data.messages);
      }
      log.debug(data);
      if(data.configurationData != undefined) {
        configurationObject = data.configurationData;
        fillFields();
      } else {
        log.error('NO CONFIG RECEIVED!!');
      }
      enableForm();
    },
    error: function(result, responseText) { 
      setMessage(false, 'Save failed', responseText);
      enableForm();
    }
  });  
}