
/*
 * Tied to the uploadXML-button
 * Collects the file to upload and does some basic checks before sending it to the backend
 */
function checkConfigUploadFile(event) {
  disableForm();
  file = event.target.files[0];
  clearFileInput();

  if(file != undefined) {
    if(file.size > 50000) {
      setMessage(false,'File is too big',file.size); 
      enableForm();
    } else if( file.type != 'text/xml') {
      setMessage(false,'Wrong file type','File type must be text/xml but is ' + file.type); 
      enableForm();
    } else {
      uploadConfig(file);
    }    
  } 
}

/*
 * Uploads the configuration as XML to the and fills the form fields
 * with the JSON-data received from the backend
 */
function uploadConfig(configUploadFile) {
  disableForm();
  var data = new FormData();
  data.append('config',configUploadFile);
    
  AJS.$.ajax({
    url: baseUrl + "/rest/samlsso-admin/1.0/xml",
    type: "PUT",
    cache: false,
    dataType: "json",
    data: data,
    contentType: false,
    processData: false,
    success: function(data) {  
      if(data.ok) {
        setMessage(true, 'Import successful, click save to apply', data.messages);
      } else {
        setMessage(false, 'Import failed', data.messages);
      }
      log.debug(data);
      if(data.configurationData != undefined) {
        configurationObject = data.configurationData;
        fillFields();
      }
      enableForm();
    },
    error: function(result) { 
      setMessage(false,'Import failed',result.responseText); 
      enableForm();
    }
  });     
}

/*
 * Clears the file input by triggering a click()-event on the FancyFileInput-clear-button
 */
function clearFileInput() {
  button = AJS.$('#config-upload').siblings(".ffi-clear");
  if(button != undefined) {
    button.click();  
  }
}
