/*
 * Helper functions
 */

/*
 *  Escape newline chars for being transmitted with JSON over the wire
 */
function escapeNewLineChars(valueToEscape) {
	if (valueToEscape != null && valueToEscape != "") {
		return valueToEscape.replace(/\n/g, "\\n");
	} else {
		return valueToEscape;
	}
}

function replaceNewlinesWithCommas(text) {
    if(text != null && text != undefined) {
      var replaced = text.replace(/[\n\r]/g,',');
      return replaced;
    } else {
      return text;
    }
}

function replaceCommasWithNewlines(text) {
    if(text != null && text != undefined) {
      var replaced = text.replace(/,/g,'\n');
      return replaced;
    } else {
      return text;
    }
}

function escapeHtmlAndNewlines(text) {
	var entityMap = {
			"&": "&amp;",
			"<": "&lt;",
			">": "&gt;",
			'"': '&quot;',
			"'": '&#39;',
			"/": '&#x2F;'
	};

	if (text != null && text != "") {
		var htmlEscaped = text.replace(/[&<>"'\/]/g, function (s) { return entityMap[s]; });
		return htmlEscaped.replace(/\n/g, "</br>");
	} else {
		return "";
	}
}

/*
 * Disables the form fields and shows the waitingmessage
 */
function disableForm() {
  AJS.$(".disableable :input").prop('disabled',true);
  AJS.$("#waitmessage").show();
}

/*
 * Enables the form fields, hides the waitingmessage 
 * and scrolls to the top of the page 
 */
function enableForm() {
  AJS.$(".disableable :input").prop('disabled',false);
  AJS.$("#waitmessage").hide();
  window.scrollTo(0, 0);
}

function setMessage(ok, title, body) {
  AJS.$("#aui-message-bar").empty(); 
  var bodyContent;
  if ( body instanceof Array) {
    bodyContent = '<ul>'
    for (var i = 0; i < body.length; i++) {
      bodyContent += '<li>' + body[i] + '</li>'
    }
    bodyContent += '</ul>'
  } else {
    bodyContent = body;
  } 
  if(ok) {
    AJS.messages.success({ title: title, body: bodyContent, closeable:false });
  } else  {
    AJS.messages.error({ title: title, body: bodyContent, closeable:false });
  }
  window.scrollTo(0, 0);
}

/*
 * Adds the options to a select field
 * options is a map, the key is the option's display name, the value the option value
 */
function setSelectOptions(selectElement,options,addOther) {
  var existingvalue = selectElement.val();
  selectElement.empty();
  if(addOther) {
    selectElement.append('<option value="">other</option>')
  }
  for(var key in options) {
    if (options.hasOwnProperty(key)){   
      var val = options[key]; 
      selectElement.append('<option value="'+ val + '">' + key + '</option>')
    }
  }
  selectElement.val(existingvalue);
}

/*
 * Removes null-elements from all arrays within the configurationObject
 */
function cleanupConfig() {
  cleanupConfigObject(configurationObject);
}

/*
 * Called recursively to remove null elements from all arrays and contained arrays in the dataObject
 */
function cleanupConfigObject(dataObject) {
  AJS.$.each( dataObject, function( key,valueObject ) {
    var type = AJS.$.type(valueObject);
    if(type == 'array') {
      // Add all non-null values to a new array and replace the existing one with it
      var newArray = []
      AJS.$.each( valueObject, function( index, childValueObject ) {
        if(childValueObject != null) {
          newArray.push(childValueObject);
          // Call myself for every child-array found
          cleanupConfigObject(childValueObject);
        }
      });
      dataObject[key] = newArray;
    } 
  });
}