/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.namespace.QName;
import org.opensaml.Configuration;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.saml2.metadata.provider.ObservableMetadataProvider;
import org.opensaml.security.MetadataCriteria;
import org.opensaml.security.SAMLMDCredentialContext;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.AbstractCriteriaFilteringCredentialResolver;
import org.opensaml.xml.security.credential.BasicCredential;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCriteria;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataCredentialResolver
extends AbstractCriteriaFilteringCredentialResolver {
    private final Logger log = LoggerFactory.getLogger(MetadataCredentialResolver.class);
    private MetadataProvider metadata;
    private Map<MetadataCacheKey, SoftReference<Collection<Credential>>> cache;
    private KeyInfoCredentialResolver keyInfoCredentialResolver;
    private ReadWriteLock rwlock;

    public MetadataCredentialResolver(MetadataProvider metadataProvider) {
        if (metadataProvider == null) {
            throw new IllegalArgumentException("Metadata provider may not be null");
        }
        this.metadata = metadataProvider;
        this.cache = new HashMap<MetadataCacheKey, SoftReference<Collection<Credential>>>();
        this.keyInfoCredentialResolver = Configuration.getGlobalSecurityConfiguration().getDefaultKeyInfoCredentialResolver();
        this.rwlock = new ReentrantReadWriteLock();
        if (this.metadata instanceof ObservableMetadataProvider) {
            ObservableMetadataProvider observable = (ObservableMetadataProvider)metadataProvider;
            observable.getObservers().add(new MetadataProviderObserver());
        }
    }

    public KeyInfoCredentialResolver getKeyInfoCredentialResolver() {
        return this.keyInfoCredentialResolver;
    }

    public void setKeyInfoCredentialResolver(KeyInfoCredentialResolver keyInfoResolver) {
        this.keyInfoCredentialResolver = keyInfoResolver;
    }

    protected ReadWriteLock getReadWriteLock() {
        return this.rwlock;
    }

    @Override
    protected Iterable<Credential> resolveFromSource(CriteriaSet criteriaSet) throws SecurityException {
        this.checkCriteriaRequirements(criteriaSet);
        String entityID = criteriaSet.get(EntityIDCriteria.class).getEntityID();
        MetadataCriteria mdCriteria = criteriaSet.get(MetadataCriteria.class);
        QName role = mdCriteria.getRole();
        String protocol = mdCriteria.getProtocol();
        UsageCriteria usageCriteria = criteriaSet.get(UsageCriteria.class);
        UsageType usage = null;
        usage = usageCriteria != null ? usageCriteria.getUsage() : UsageType.UNSPECIFIED;
        this.log.debug("Forcing on-demand metadata provider refresh if necessary");
        try {
            this.metadata.getMetadata();
        }
        catch (MetadataProviderException e) {
            // empty catch block
        }
        MetadataCacheKey cacheKey = new MetadataCacheKey(entityID, role, protocol, usage);
        Collection<Credential> credentials = this.retrieveFromCache(cacheKey);
        if (credentials == null) {
            credentials = this.retrieveFromMetadata(entityID, role, protocol, usage);
            this.cacheCredentials(cacheKey, credentials);
        }
        return credentials;
    }

    protected void checkCriteriaRequirements(CriteriaSet criteriaSet) {
        EntityIDCriteria entityCriteria = criteriaSet.get(EntityIDCriteria.class);
        MetadataCriteria mdCriteria = criteriaSet.get(MetadataCriteria.class);
        if (entityCriteria == null) {
            throw new IllegalArgumentException("Entity criteria must be supplied");
        }
        if (mdCriteria == null) {
            throw new IllegalArgumentException("SAML metadata criteria must be supplied");
        }
        if (DatatypeHelper.isEmpty(entityCriteria.getEntityID())) {
            throw new IllegalArgumentException("Credential owner entity ID criteria value must be supplied");
        }
        if (mdCriteria.getRole() == null) {
            throw new IllegalArgumentException("Credential metadata role criteria value must be supplied");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Credential> retrieveFromCache(MetadataCacheKey cacheKey) {
        this.log.debug("Attempting to retrieve credentials from cache using index: {}", (Object)cacheKey);
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        this.log.trace("Read lock over cache acquired");
        try {
            SoftReference<Collection<Credential>> reference;
            if (this.cache.containsKey(cacheKey) && (reference = this.cache.get(cacheKey)).get() != null) {
                this.log.debug("Retrieved credentials from cache using index: {}", (Object)cacheKey);
                Collection<Credential> collection = reference.get();
                return collection;
            }
        }
        finally {
            readLock.unlock();
            this.log.trace("Read lock over cache released");
        }
        this.log.debug("Unable to retrieve credentials from cache using index: {}", (Object)cacheKey);
        return null;
    }

    protected Collection<Credential> retrieveFromMetadata(String entityID, QName role, String protocol, UsageType usage) throws SecurityException {
        this.log.debug("Attempting to retrieve credentials from metadata for entity: {}", (Object)entityID);
        HashSet<Credential> credentials = new HashSet<Credential>(3);
        List<RoleDescriptor> roleDescriptors = this.getRoleDescriptors(entityID, role, protocol);
        if (roleDescriptors == null || roleDescriptors.isEmpty()) {
            return credentials;
        }
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            List<KeyDescriptor> keyDescriptors = roleDescriptor.getKeyDescriptors();
            if (keyDescriptors == null || keyDescriptors.isEmpty()) {
                return credentials;
            }
            for (KeyDescriptor keyDescriptor : keyDescriptors) {
                UsageType mdUsage = keyDescriptor.getUse();
                if (mdUsage == null) {
                    mdUsage = UsageType.UNSPECIFIED;
                }
                if (!this.matchUsage(mdUsage, usage) || keyDescriptor.getKeyInfo() == null) continue;
                CriteriaSet critSet = new CriteriaSet();
                critSet.add(new KeyInfoCriteria(keyDescriptor.getKeyInfo()));
                Iterable creds = this.getKeyInfoCredentialResolver().resolve(critSet);
                if (credentials == null) continue;
                for (Credential cred : creds) {
                    if (cred instanceof BasicCredential) {
                        BasicCredential basicCred = (BasicCredential)cred;
                        basicCred.setEntityId(entityID);
                        basicCred.setUsageType(mdUsage);
                        basicCred.getCredentalContextSet().add(new SAMLMDCredentialContext(keyDescriptor));
                    }
                    credentials.add(cred);
                }
            }
        }
        return credentials;
    }

    protected boolean matchUsage(UsageType metadataUsage, UsageType criteriaUsage) {
        if (metadataUsage == UsageType.UNSPECIFIED || criteriaUsage == UsageType.UNSPECIFIED) {
            return true;
        }
        return metadataUsage == criteriaUsage;
    }

    protected List<RoleDescriptor> getRoleDescriptors(String entityID, QName role, String protocol) throws SecurityException {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Retrieving metadata for entity '{}' in role '{}' for protocol '{}'", new Object[]{entityID, role, protocol});
            }
            if (DatatypeHelper.isEmpty(protocol)) {
                return this.metadata.getRole(entityID, role);
            }
            RoleDescriptor roleDescriptor = this.metadata.getRole(entityID, role, protocol);
            if (roleDescriptor == null) {
                return null;
            }
            ArrayList<RoleDescriptor> roles = new ArrayList<RoleDescriptor>();
            roles.add(roleDescriptor);
            return roles;
        }
        catch (MetadataProviderException e) {
            this.log.error("Unable to read metadata from provider", (Throwable)e);
            throw new SecurityException("Unable to read metadata provider", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheCredentials(MetadataCacheKey cacheKey, Collection<Credential> credentials) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        writeLock.lock();
        this.log.trace("Write lock over cache acquired");
        try {
            this.cache.put(cacheKey, new SoftReference<Collection<Credential>>(credentials));
            this.log.debug("Added new credential collection to cache with key: {}", (Object)cacheKey);
        }
        finally {
            writeLock.unlock();
            this.log.trace("Write lock over cache released");
        }
    }

    protected class MetadataProviderObserver
    implements ObservableMetadataProvider.Observer {
        protected MetadataProviderObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(MetadataProvider provider) {
            Lock writeLock = MetadataCredentialResolver.this.getReadWriteLock().writeLock();
            writeLock.lock();
            MetadataCredentialResolver.this.log.trace("Write lock over cache acquired");
            try {
                MetadataCredentialResolver.this.cache.clear();
                MetadataCredentialResolver.this.log.debug("Credential cache cleared");
            }
            finally {
                writeLock.unlock();
                MetadataCredentialResolver.this.log.trace("Write lock over cache released");
            }
        }
    }

    protected class MetadataCacheKey {
        private String id;
        private QName role;
        private String protocol;
        private UsageType usage;

        protected MetadataCacheKey(String entityID, QName entityRole, String entityProtocol, UsageType entityUsage) {
            if (entityID == null) {
                throw new IllegalArgumentException("Entity ID may not be null");
            }
            if (entityRole == null) {
                throw new IllegalArgumentException("Entity role may not be null");
            }
            if (entityUsage == null) {
                throw new IllegalArgumentException("Credential usage may not be null");
            }
            this.id = entityID;
            this.role = entityRole;
            this.protocol = entityProtocol;
            this.usage = entityUsage;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MetadataCacheKey)) {
                return false;
            }
            MetadataCacheKey other = (MetadataCacheKey)obj;
            if (!this.id.equals(other.id) || !this.role.equals(other.role) || this.usage != other.usage) {
                return false;
            }
            return !(this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol));
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.id.hashCode();
            result = 37 * result + this.role.hashCode();
            if (this.protocol != null) {
                result = 37 * result + this.protocol.hashCode();
            }
            result = 37 * result + this.usage.hashCode();
            return result;
        }

        public String toString() {
            return String.format("[%s,%s,%s,%s]", new Object[]{this.id, this.role, this.protocol, this.usage});
        }
    }
}

