/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.ssl.LogHelper;

public class LogWrapper {
    static final String[] LEVELS = new String[]{"+", " ", "!", "*", "#"};
    static final String TIMESTAMP_PATTERN = "zzz:yyyy-MM-dd/HH:mm:ss.SSS";
    static final int TIMESTAMP_LENGTH = "zzz:yyyy-MM-dd/HH:mm:ss.SSS".length();
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static final DateFormat DF = new SimpleDateFormat("zzz:yyyy-MM-dd/HH:mm:ss.SSS");
    private static final LogWrapper NOOP = new LogWrapper();
    private static final boolean DEBUG = true;
    public static final boolean log4j;
    private static volatile OutputStream backup;
    private static volatile PrintStream wrappingPrintStream;
    private final LogHelper h;

    public static boolean isLog4jAvailable() {
        return log4j;
    }

    public static LogWrapper getLogger(Class c) {
        return log4j ? new LogWrapper(c) : NOOP;
    }

    public static LogWrapper getLogger(String s) {
        return log4j ? new LogWrapper(s) : NOOP;
    }

    private LogWrapper() {
        this.h = null;
    }

    private LogWrapper(Class c) {
        this.h = new LogHelper(c);
    }

    private LogWrapper(String s) {
        this.h = new LogHelper(s);
    }

    public void debug(Object o) {
        if (this.t(0, o, null)) {
            this.h.debug(o);
        }
    }

    public void debug(Object o, Throwable t) {
        if (this.t(0, o, t)) {
            this.h.debug(o, t);
        }
    }

    public void info(Object o) {
        if (this.t(1, o, null)) {
            this.h.info(o);
        }
    }

    public void info(Object o, Throwable t) {
        if (this.t(1, o, t)) {
            this.h.info(o, t);
        }
    }

    public void warn(Object o) {
        if (this.t(2, o, null)) {
            this.h.warn(o);
        }
    }

    public void warn(Object o, Throwable t) {
        if (this.t(2, o, t)) {
            this.h.warn(o, t);
        }
    }

    public void error(Object o) {
        if (this.t(3, o, null)) {
            this.h.error(o);
        }
    }

    public void error(Object o, Throwable t) {
        if (this.t(3, o, t)) {
            this.h.error(o, t);
        }
    }

    public void fatal(Object o) {
        if (this.t(4, o, null)) {
            this.h.fatal(o);
        }
    }

    public void fatal(Object o, Throwable t) {
        if (this.t(4, o, t)) {
            this.h.fatal(o, t);
        }
    }

    public boolean isDebugEnabled() {
        return log4j ? this.h.isDebugEnabled() : true;
    }

    public boolean isInfoEnabled() {
        return !log4j || this.h.isInfoEnabled();
    }

    public Object getLog4jLogger() {
        return log4j ? this.h.getLog4jLogger() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean t(int level, Object o, Throwable t) {
        if (log4j) {
            return true;
        }
        if (backup != null) {
            String s = "";
            if (o != null) {
                try {
                    s = (String)o;
                }
                catch (ClassCastException cce) {
                    s = o.toString();
                }
            }
            int len = s.length() + TIMESTAMP_LENGTH + 9;
            String timestamp = DF.format(new Date());
            StringBuffer buf = new StringBuffer(len);
            buf.append(timestamp);
            if (LEVELS[level].length() == 1) {
                buf.append(LEVELS[level]);
            } else {
                buf.append(' ');
                buf.append(LEVELS[level]);
                buf.append(' ');
            }
            buf.append(s);
            buf.append(LINE_SEPARATOR);
            s = buf.toString();
            byte[] logBytes = s.getBytes();
            try {
                if (t == null) {
                    backup.write(logBytes);
                } else {
                    OutputStream outputStream = backup;
                    synchronized (outputStream) {
                        backup.write(logBytes);
                        if (t != null) {
                            if (wrappingPrintStream == null) {
                                wrappingPrintStream = new PrintStream(backup, false);
                            }
                            t.printStackTrace(wrappingPrintStream);
                            wrappingPrintStream.flush();
                        }
                    }
                }
                backup.flush();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.toString());
            }
        }
        return false;
    }

    public static void setBackupLogFile(String f) throws IOException {
        if (!log4j) {
            OutputStream out = new FileOutputStream(f, true);
            out = new BufferedOutputStream(out);
            LogWrapper.setBackupStream(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBackupStream(OutputStream os) {
        if (backup != null) {
            OutputStream outputStream = backup;
            synchronized (outputStream) {
                wrappingPrintStream = null;
                backup = os;
            }
        } else {
            wrappingPrintStream = null;
            backup = os;
        }
    }

    public static OutputStream getBackupStream() {
        return backup;
    }

    static {
        backup = System.out;
        wrappingPrintStream = null;
        boolean avail = false;
        try {
            LogHelper lh = new LogHelper(LogWrapper.class);
            lh.hashCode();
            avail = true;
        }
        catch (Throwable t) {
            avail = false;
        }
        finally {
            log4j = avail;
        }
    }
}

