/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.samlprocessor;

import com.resolution.atlasplugins.samlsso.configuration.IdpConfiguration;
import com.resolution.samlprocessor.EasySSLProtocolSocketFactory;
import com.resolution.samlprocessor.InformationFromIdPMetadata;
import com.resolution.samlprocessor.MetadataException;
import com.resolution.samlprocessor.ResponseIDStore;
import com.resolution.samlprocessor.SAMLProcessorException;
import com.resolution.samlprocessor.SAMLResponseContent;
import com.resolution.samlprocessor.SingleIdpSAMLProcessor;
import com.resolution.samlprocessor.XmlStringMetadataProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml2.metadata.NameIDFormat;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SAMLProcessor {
    private static final Logger logger = LoggerFactory.getLogger(SAMLProcessor.class);
    protected final Map<Integer, SingleIdpSAMLProcessor> samlProcessorsById;
    protected final Map<String, SingleIdpSAMLProcessor> samlProcessorsByIssuer;
    protected final ResponseIDStore responseIDStore = new ResponseIDStore();
    protected final boolean enforceResponseValidityDates;
    protected final boolean enforceResponseIDUniqueness;
    protected final int clockSkew;
    protected final SingleIdpSAMLProcessor singleSamlProcessor;

    public SAMLProcessor(String consumerURL, List<IdpConfiguration> idpConfigurations, boolean enforceResponseValidityDates, boolean enforceResponseIDUniqueness, int clockSkew) throws SAMLProcessorException {
        this.samlProcessorsById = new HashMap<Integer, SingleIdpSAMLProcessor>();
        this.samlProcessorsByIssuer = new HashMap<String, SingleIdpSAMLProcessor>();
        this.enforceResponseIDUniqueness = enforceResponseIDUniqueness;
        this.enforceResponseValidityDates = enforceResponseValidityDates;
        this.clockSkew = clockSkew;
        try {
            if (idpConfigurations.size() == 1 && (idpConfigurations.get(0).getIssuer() == null || idpConfigurations.get(0).getIssuer().trim().isEmpty())) {
                IdpConfiguration idpConfiguration = idpConfigurations.get(0);
                this.singleSamlProcessor = new SingleIdpSAMLProcessor(idpConfiguration.getUrl(), idpConfiguration.getIssuer(), idpConfiguration.getUseridAttribute(), idpConfiguration.getEmailAttribute(), idpConfiguration.getFullnameAttribute(), idpConfiguration.getGroupAttribute(), consumerURL, idpConfiguration.getRelayStateParameterName(), idpConfiguration.getCertificate(), idpConfiguration.getSecondCertificate(), idpConfiguration.isOmitRequestedAuthnContext(), idpConfiguration.getUseridTransformationRegex(), idpConfiguration.getUseridTransformationReplacement(), idpConfiguration.isLowercaseConvert(), idpConfiguration.isLowercaseConvertGroups(), idpConfiguration.getGroupsForNewUsersList(), idpConfiguration.getGroupsForNewSdCustomersList(), idpConfiguration.isEnableUserUpdate(), idpConfiguration.isRemoveFromGroups(), idpConfiguration.isUpdateExisting(), idpConfiguration.getDirectoryIdForNewUsers(), this.enforceResponseValidityDates, this.clockSkew);
            } else {
                this.singleSamlProcessor = null;
                for (IdpConfiguration idpConfiguration : idpConfigurations) {
                    SingleIdpSAMLProcessor processor = new SingleIdpSAMLProcessor(idpConfiguration.getUrl(), idpConfiguration.getIssuer(), idpConfiguration.getUseridAttribute(), idpConfiguration.getEmailAttribute(), idpConfiguration.getFullnameAttribute(), idpConfiguration.getGroupAttribute(), consumerURL, idpConfiguration.getRelayStateParameterName(), idpConfiguration.getCertificate(), idpConfiguration.getSecondCertificate(), idpConfiguration.isOmitRequestedAuthnContext(), idpConfiguration.getUseridTransformationRegex(), idpConfiguration.getUseridTransformationReplacement(), idpConfiguration.isLowercaseConvert(), idpConfiguration.isLowercaseConvertGroups(), idpConfiguration.getGroupsForNewUsersList(), idpConfiguration.getGroupsForNewSdCustomersList(), idpConfiguration.isEnableUserUpdate(), idpConfiguration.isRemoveFromGroups(), idpConfiguration.isUpdateExisting(), idpConfiguration.getDirectoryIdForNewUsers(), this.enforceResponseValidityDates, this.clockSkew);
                    this.samlProcessorsById.put(idpConfiguration.getId(), processor);
                    this.samlProcessorsByIssuer.put(idpConfiguration.getIssuer(), processor);
                }
            }
        }
        catch (CertificateException e) {
            throw new SAMLProcessorException(e);
        }
    }

    public String buildRedirectToIdPurl(HttpServletRequest request, String originalUrl, int idpid, String issuerUrl, Map<String, String> parametersToPassthrough) throws SAMLProcessorException {
        if (this.singleSamlProcessor != null) {
            return this.singleSamlProcessor.buildRedirectToIdPurl(request, originalUrl, issuerUrl, parametersToPassthrough);
        }
        SingleIdpSAMLProcessor processor = this.samlProcessorsById.get(idpid);
        if (processor == null) {
            throw new SAMLProcessorException("No Identity provider found with id " + idpid);
        }
        return processor.buildRedirectToIdPurl(request, originalUrl, issuerUrl, parametersToPassthrough);
    }

    public String buildPOSTtoIdPFormHtml(String originalUrl, int idpid, String issuerUrl, Map<String, String> parametersToPassthrough) throws SAMLProcessorException {
        if (this.singleSamlProcessor != null) {
            return this.singleSamlProcessor.buildPOSTtoIdPFormHtml(originalUrl, issuerUrl, parametersToPassthrough);
        }
        SingleIdpSAMLProcessor processor = this.samlProcessorsById.get(idpid);
        if (processor == null) {
            throw new SAMLProcessorException("No Identity provider found with id " + idpid);
        }
        return processor.buildPOSTtoIdPFormHtml(originalUrl, issuerUrl, parametersToPassthrough);
    }

    public Element readElementFromBase64samlResponseString(String responseString) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        logger.debug("Setting http://xml.org/sax/features/external-general-entities to false");
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        logger.debug("Setting http://apache.org/xml/features/disallow-doctype-decl to true");
        documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        byte[] decodedBytes = Base64.decode(responseString);
        String decodedResponseMessage = new String(decodedBytes);
        logger.debug("Unformatted SAML Response:");
        logger.debug(decodedResponseMessage);
        ByteArrayInputStream is = new ByteArrayInputStream(decodedResponseMessage.getBytes());
        Document document = docBuilder.parse(is);
        Element element = document.getDocumentElement();
        return element;
    }

    public SAMLResponseContent processSAMLResponseMessage(String base64samlResponseString) throws SAMLProcessorException {
        logger.debug("Base64-encoded SAML Response: {}", (Object)base64samlResponseString);
        try {
            Element element = this.readElementFromBase64samlResponseString(base64samlResponseString);
            return this.processSAMLResponseMessage(element);
        }
        catch (Exception e) {
            throw new SAMLProcessorException(e);
        }
    }

    public SAMLResponseContent processSAMLResponseMessage(Element element) throws SAMLProcessorException {
        try {
            UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            XMLObject responseXmlObj = unmarshaller.unmarshall(element);
            if (responseXmlObj != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("SAMLResponse:\n" + SAMLProcessor.elementToString(responseXmlObj.getDOM()));
                }
                Response response = (Response)responseXmlObj;
                Issuer issuer = response.getIssuer();
                String issuerName = issuer.getValue();
                if (this.enforceResponseIDUniqueness) {
                    String responseID = response.getID();
                    if (this.responseIDStore.contains(responseID)) {
                        throw new SAMLProcessorException("Response ID " + responseID + " has already been used.");
                    }
                    this.responseIDStore.add(responseID);
                }
                logger.debug("Issuer is {}", (Object)issuerName);
                if (this.singleSamlProcessor != null) {
                    return this.singleSamlProcessor.processSAMLResponse(response);
                }
                SingleIdpSAMLProcessor processor = this.samlProcessorsByIssuer.get(issuerName);
                if (processor == null) {
                    throw new SAMLProcessorException("No SAMLProcessor configured for IdP " + issuerName);
                }
                return processor.processSAMLResponse(response);
            }
            throw new SAMLProcessorException("SAML Response is null");
        }
        catch (Exception e) {
            throw new SAMLProcessorException(e);
        }
    }

    public String generateMetadata(String consumerURL) throws SAMLProcessorException {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        EntityDescriptor spEntityDescriptor = (EntityDescriptor)builderFactory.getBuilder(EntityDescriptor.DEFAULT_ELEMENT_NAME).buildObject(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        spEntityDescriptor.setEntityID(consumerURL);
        SPSSODescriptor spSSODescriptor = (SPSSODescriptor)builderFactory.getBuilder(SPSSODescriptor.DEFAULT_ELEMENT_NAME).buildObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        spSSODescriptor.setWantAssertionsSigned(true);
        AssertionConsumerService assertionConsumerService = (AssertionConsumerService)builderFactory.getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME).buildObject(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        assertionConsumerService.setIndex(0);
        assertionConsumerService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        assertionConsumerService.setLocation(consumerURL);
        spSSODescriptor.getAssertionConsumerServices().add(assertionConsumerService);
        NameIDFormat nameIDFormat = (NameIDFormat)builderFactory.getBuilder(NameIDFormat.DEFAULT_ELEMENT_NAME).buildObject(NameIDFormat.DEFAULT_ELEMENT_NAME);
        nameIDFormat.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        spSSODescriptor.getNameIDFormats().add(nameIDFormat);
        spSSODescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        spEntityDescriptor.getRoleDescriptors().add(spSSODescriptor);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Marshaller out = Configuration.getMarshallerFactory().getMarshaller(spEntityDescriptor);
            out.marshall((XMLObject)spEntityDescriptor, document);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            DOMSource source = new DOMSource(document);
            t.transform(source, streamResult);
            stringWriter.close();
            String resultString = stringWriter.toString();
            logger.debug(resultString);
            return resultString;
        }
        catch (Exception e) {
            throw new SAMLProcessorException("Error generating Metadata", e);
        }
    }

    public InformationFromIdPMetadata readIdpMetadataFromString(String xmlString) throws MetadataException {
        try {
            return this.readIdpMetadata(new XmlStringMetadataProvider(xmlString));
        }
        catch (UnmarshallingException e) {
            throw new MetadataException(e);
        }
        catch (MetadataProviderException e) {
            throw new MetadataException(e);
        }
    }

    public InformationFromIdPMetadata readIdpMetadataFromURL(String urlString, boolean ignoreCertificate) throws MetadataException, URIException, HttpException, IOException {
        GetMethod httpGET;
        URI uri = new URI(urlString, true);
        HttpConnection con = new HttpConnection(uri.getHost(), uri.getPort());
        HttpClient client = new HttpClient();
        HostConfiguration hc = new HostConfiguration();
        if (ignoreCertificate) {
            EasySSLProtocolSocketFactory easySSLFac = new EasySSLProtocolSocketFactory();
            Protocol easyhttps = new Protocol("https", (ProtocolSocketFactory)easySSLFac, 443);
            con.setProtocol(easyhttps);
            hc.setHost(uri.getHost(), uri.getPort(), easyhttps);
            httpGET = new GetMethod(uri.getPath());
        } else {
            httpGET = new GetMethod(urlString);
        }
        client.executeMethod(hc, (HttpMethod)httpGET);
        String xmlString = httpGET.getResponseBodyAsString();
        return this.readIdpMetadataFromString(xmlString);
    }

    public InformationFromIdPMetadata readIdpMetadata(MetadataProvider metadataProvider) throws MetadataException {
        InformationFromIdPMetadata ret = new InformationFromIdPMetadata();
        try {
            String entityId;
            EntityDescriptor entityDescriptor = (EntityDescriptor)metadataProvider.getMetadata();
            ret.entityId = entityId = entityDescriptor.getEntityID();
            IDPSSODescriptor idpSSODescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
            for (SingleSignOnService sso : idpSSODescriptor.getSingleSignOnServices()) {
                if (!sso.getBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) continue;
                ret.ssoPOSTUrl = sso.getLocation();
            }
            for (KeyDescriptor keyDescriptor : idpSSODescriptor.getKeyDescriptors()) {
                if (keyDescriptor.getUse() != UsageType.SIGNING) continue;
                for (X509Data x509data : keyDescriptor.getKeyInfo().getX509Datas()) {
                    for (X509Certificate x509cert : x509data.getX509Certificates()) {
                        ret.signingCertificate = x509cert.getValue();
                    }
                }
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (Attribute attribute : idpSSODescriptor.getAttributes()) {
                attributes.put(attribute.getFriendlyName(), attribute.getName());
            }
            ret.attributes = attributes;
        }
        catch (MetadataProviderException e) {
            throw new MetadataException(e);
        }
        return ret;
    }

    public static String elementToString(Element xml) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            t.transform(new DOMSource(xml), new StreamResult(new OutputStreamWriter((OutputStream)bo, "utf-8")));
            String ret = new String(bo.toString("UTF8"));
            return ret;
        }
        catch (TransformerException e) {
            logger.warn("Exception during logging XML", (Throwable)e);
            return "Creating String from Element failed: TransformerException: " + e.getMessage();
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("Exception during logging XML", (Throwable)e);
            return "Creating String from Element failed: UnsupportedEncodingException: " + e.getMessage();
        }
    }

    static {
        logger.debug("Bootstrapping OpenSAML");
        try {
            DefaultBootstrap.bootstrap();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Bootstrapping OpenSAML failed", e);
        }
    }
}

