/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugins.rest.common.multipart.FilePart;
import com.atlassian.plugins.rest.common.multipart.MultipartFormParam;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.resolution.atlasplugins.samlsso.SSOPluginInfo;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationDefaultSetter;
import com.resolution.atlasplugins.samlsso.configuration.PluginConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.UpdateConfigurationResponse;
import com.resolution.atlasplugins.samlsso.servlet.SupportInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/xml")
public class XmlImportExportRestResource {
    private final UserManager userManager;
    private final PluginConfiguration pluginConfiguration;
    private final CacheControl cacheControl;
    private final ApplicationProperties applicationProperties;
    private final PluginLicenseManager licenseManager;
    private final PluginAccessor pluginAccessor;
    private final ConfigurationDefaultSetter configurationDefaultSetter;
    private static final Logger logger = LoggerFactory.getLogger(XmlImportExportRestResource.class);

    public XmlImportExportRestResource(UserManager userManager, PluginConfiguration pluginConfiguration, PluginLicenseManager licenseManager, ApplicationProperties applicationProperties, PluginAccessor pluginAccessor, ConfigurationDefaultSetter configurationDefaultSetter) {
        this.userManager = userManager;
        this.pluginConfiguration = pluginConfiguration;
        this.applicationProperties = applicationProperties;
        this.licenseManager = licenseManager;
        this.pluginAccessor = pluginAccessor;
        this.configurationDefaultSetter = configurationDefaultSetter;
        this.cacheControl = new CacheControl();
        this.cacheControl.setNoCache(true);
    }

    @GET
    @Produces(value={"application/xml"})
    public Response get(@Context HttpServletRequest request) {
        UserProfile userProfile = this.userManager.getRemoteUser(request);
        if (userProfile == null || !this.userManager.isSystemAdmin(userProfile.getUserKey())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SupportInfo supportInfo = new SupportInfo();
        ConfigurationData configData = this.pluginConfiguration.getConfigurationData();
        supportInfo.configurationData = this.configurationDefaultSetter.clearDefaults(configData);
        supportInfo.ssoPluginInfo = new SSOPluginInfo(this.applicationProperties, this.licenseManager, this.pluginAccessor);
        StringWriter writer = new StringWriter();
        JAXB.marshal((Object)supportInfo, (Writer)writer);
        String xml = writer.toString();
        return Response.ok((Object)xml).header("Content-Disposition", (Object)"attachment; filename=samlSingleSignOn.xml").cacheControl(this.cacheControl).build();
    }

    @PUT
    @Consumes(value={"multipart/form-data"})
    public Response uploadConfiguration(@MultipartFormParam(value="config") FilePart filePart, @Context HttpServletRequest request) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        UserProfile userProfile = this.userManager.getRemoteUser(request);
        if (userProfile == null || !this.userManager.isSystemAdmin(userProfile.getUserKey())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SupportInfo supportInfo = null;
        try {
            supportInfo = (SupportInfo)JAXB.unmarshal((InputStream)filePart.getInputStream(), SupportInfo.class);
        }
        catch (IOException e) {
            logger.warn("Reading configuration from upload failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Unmarshalling SupportInfo-object failed: " + e.getMessage())).build();
        }
        catch (DataBindingException e) {
            logger.warn("Reading configuration from upload failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Unmarshalling SupportInfo-object failed: " + e.getMessage())).build();
        }
        if (supportInfo == null || supportInfo.configurationData == null || supportInfo.ssoPluginInfo == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Parsing data failed").build();
        }
        ConfigurationData config = supportInfo.configurationData;
        this.configurationDefaultSetter.addDefaults(config);
        List<String> validationMessages = this.pluginConfiguration.validate(config);
        if (validationMessages.isEmpty()) {
            return Response.ok((Object)new UpdateConfigurationResponse(true, validationMessages, config)).cacheControl(cacheControl).build();
        }
        return Response.ok((Object)new UpdateConfigurationResponse(false, validationMessages, config)).cacheControl(cacheControl).build();
    }
}

