/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.resolution.atlasplugins.samlsso.LicenseChecker;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectToSsoFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(RedirectToSsoFilter.class);
    private static final String ALREADY_FILTERED = RedirectToSsoFilter.class.getName() + "_already_filtered";
    private final SamlSsoService samlSsoService;
    private final LicenseChecker licenseChecker;

    public RedirectToSsoFilter(SamlSsoService samlSsoComponent, LicenseChecker licenseChecker) {
        this.samlSsoService = samlSsoComponent;
        this.licenseChecker = licenseChecker;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req.getAttribute(ALREADY_FILTERED) != null) {
            chain.doFilter(req, res);
        } else {
            req.setAttribute(ALREADY_FILTERED, (Object)"yes");
            HttpServletRequest httpReq = (HttpServletRequest)req;
            String redirectDestination = this.samlSsoService.getRedirectURLForRequest(httpReq);
            if (redirectDestination == null) {
                chain.doFilter(req, res);
            } else {
                LicenseChecker.LicenseCheckResult lcheck = this.licenseChecker.checkLicense();
                if (!lcheck.isLicensed()) {
                    logger.error("Not redirecting, license is not valid: {}", (Object)lcheck.getMessage());
                    chain.doFilter(req, res);
                } else {
                    logger.debug("Redirecting to {}", (Object)redirectDestination);
                    HttpServletResponse httpRes = (HttpServletResponse)res;
                    httpRes.sendRedirect(redirectDestination);
                }
            }
        }
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }
}

