/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.servlet.MetadataFetchingInformation;
import com.resolution.samlprocessor.InformationFromIdPMetadata;
import com.resolution.samlprocessor.MetadataException;
import com.resolution.samlprocessor.SAMLProcessor;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.URIException;

@Path(value="/readMetadata")
public class ReadMetadataRESTResource {
    private SAMLProcessor samlProcessor;
    private final CacheControl cacheControl;

    public ReadMetadataRESTResource(SamlSsoService samlSsoService) {
        this(samlSsoService.getSamlProcessor());
    }

    public ReadMetadataRESTResource(SAMLProcessor samlProcessor) {
        this.samlProcessor = samlProcessor;
        this.cacheControl = new CacheControl();
        this.cacheControl.setNoCache(true);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response readMetadataFromURL(MetadataFetchingInformation fetchingInfo) {
        try {
            InformationFromIdPMetadata ret;
            if (fetchingInfo.useMetadataxml) {
                if (fetchingInfo.metadataXML == null || fetchingInfo.metadataXML.trim().isEmpty()) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"no XML provided").build();
                }
                ret = this.samlProcessor.readIdpMetadataFromString(fetchingInfo.metadataXML);
            } else {
                if (fetchingInfo.metadataURL == null || fetchingInfo.metadataURL.trim().isEmpty()) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"no URL provided").build();
                }
                ret = this.samlProcessor.readIdpMetadataFromURL(fetchingInfo.metadataURL, fetchingInfo.ignoreCertificate);
            }
            return Response.ok().entity((Object)ret).build();
        }
        catch (URIException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid URL").build();
        }
        catch (HttpException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Fetching Metadata from URL failed: " + e.getMessage())).build();
        }
        catch (IOException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Fetching Metadata from URL failed: " + e.getMessage())).build();
        }
        catch (MetadataException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Fetching Metadata from URL failed: " + e.getMessage())).build();
        }
    }
}

