/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.configuration.PluginConfiguration;
import com.resolution.atlasplugins.samlsso.servlet.BasicServlet;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutServlet
extends BasicServlet {
    private static final Logger logger = LoggerFactory.getLogger(LogoutServlet.class);
    private static final long serialVersionUID = -6848231299782192696L;

    public LogoutServlet(SamlSsoService samlSsoComponent, PluginConfiguration pluginConfiguration, TemplateRenderer renderer) {
        super(samlSsoComponent, pluginConfiguration, renderer);
    }

    @Override
    public void processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean test = req.getParameterMap().containsKey("test");
        if (!test) {
            try {
                boolean result = this.samlSsoService.getAuthenticatorHook().logout(req, resp);
                if (!result) {
                    this.sendError(resp, null, "Authenticator returned false.", null);
                }
                logger.debug("Authenticator.logout() returned true");
            }
            catch (AuthenticatorException e) {
                this.sendError(resp, null, null, e);
                return;
            }
        } else {
            logger.debug("Logout servlet was called with test parameter, just rendering the page.");
        }
        if (!test && this.pluginConfiguration.getLogoutUrl() != null) {
            logger.debug("Redirecting to {}", (Object)this.pluginConfiguration.getLogoutUrl());
            resp.sendRedirect(this.pluginConfiguration.getLogoutUrl());
        } else {
            HashMap<String, String> ctx = new HashMap<String, String>();
            String loginurl = this.samlSsoService.getAbsoluteLoginPageUrl();
            ctx.put("loginurl", loginurl);
            ctx.put("ssourl", this.samlSsoService.getSSOUrl());
            String result = this.renderer.renderFragment(this.pluginConfiguration.getLoggedOutPageTemplate(), ctx);
            resp.getWriter().write(result);
        }
    }
}

