/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.configuration.PluginConfiguration;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.exception.ExceptionUtils;

public abstract class BasicServlet
extends HttpServlet {
    protected final SamlSsoService samlSsoService;
    protected final PluginConfiguration pluginConfiguration;
    protected final TemplateRenderer renderer;
    private static final long serialVersionUID = 5671437898336110647L;

    public BasicServlet(SamlSsoService samlSsoService, PluginConfiguration pluginConfiguration, TemplateRenderer renderer) {
        this.samlSsoService = samlSsoService;
        this.pluginConfiguration = pluginConfiguration;
        this.renderer = renderer;
    }

    public abstract void processRequest(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    protected void sendError(HttpServletResponse resp, String userid, String message, Throwable throwable) throws ServletException, IOException {
        String fragment = this.pluginConfiguration.getErrorPageTemplate();
        HashMap<String, String> ctx = new HashMap<String, String>();
        String loginurl = this.samlSsoService.getLoginPageUrl();
        ctx.put("loginurl", loginurl);
        ctx.put("ssourl", this.samlSsoService.getSSOUrl());
        ctx.put("userid", userid);
        ctx.put("message", message);
        if (throwable != null) {
            ctx.put("stacktrace", ExceptionUtils.getStackTrace((Throwable)throwable));
            if (message == null || message.isEmpty()) {
                ctx.put("message", throwable.getMessage());
            }
        }
        resp.setContentType("text/html;charset=utf-8");
        String result = this.renderer.renderFragment(fragment, ctx);
        resp.getWriter().write(result);
    }

    protected void sendServiceDeskError(HttpServletResponse resp, String message) throws ServletException, IOException {
        String fragment = this.pluginConfiguration.getServiceDeskErrorPageTemplate();
        HashMap<String, String> ctx = new HashMap<String, String>();
        String loginurl = this.samlSsoService.getAbsoluteBaseUrl() + "/servicedesk/customer/user/login?nosso";
        ctx.put("loginurl", loginurl);
        ctx.put("ssourl", this.samlSsoService.getSSOUrl());
        ctx.put("message", message);
        resp.setContentType("text/html;charset=utf-8");
        String result = this.renderer.renderFragment(fragment, ctx);
        resp.getWriter().write(result);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }
}

