/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.LicenseChecker;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.configuration.PluginConfiguration;
import com.resolution.atlasplugins.samlsso.servlet.BasicServlet;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AdminServlet
extends BasicServlet {
    private final UserManager userManager;
    private final LicenseChecker licenseChecker;
    private final LoginUriProvider loginUriProvider;
    private static final long serialVersionUID = 1L;

    public AdminServlet(UserManager userManager, LoginUriProvider loginUriProvider, TemplateRenderer renderer, SamlSsoService samlssoService, PluginConfiguration pluginConfiguration, LicenseChecker licenseChecker) {
        super(samlssoService, pluginConfiguration, renderer);
        this.userManager = userManager;
        this.licenseChecker = licenseChecker;
        this.loginUriProvider = loginUriProvider;
    }

    @Override
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UserProfile userProfile = this.userManager.getRemoteUser(request);
        if (userProfile == null || !this.userManager.isSystemAdmin(userProfile.getUserKey())) {
            this.redirectToLogin(request, response);
            return;
        }
        LicenseChecker.LicenseCheckResult licenseCheckResult = this.licenseChecker.checkLicense();
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("licensecheck", licenseCheckResult);
        ctx.put("ownLicense", this.licenseChecker.isOwnLicense());
        ctx.put("serverId", this.licenseChecker.getServerId());
        ctx.put("loginpageurl", this.samlSsoService.getAbsoluteBaseUrl() + this.samlSsoService.getLoginPageUrl());
        ctx.put("baseurl", this.samlSsoService.getAbsoluteBaseUrl());
        ctx.put("ssourl", this.samlSsoService.getSSOUrl());
        ctx.put("ssoAuthenticator", this.samlSsoService.checkForSamlSsoAuthenticator());
        ctx.put("jira7", this.samlSsoService.isJira7());
        ctx.put("jira6", this.samlSsoService.isJira6());
        ctx.put("servicedesk", this.samlSsoService.isJiraServiceDesk());
        ctx.put("confluence", this.samlSsoService.isConfluence());
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("admin-main.vm", ctx, (Writer)response.getWriter());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

