/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.confluence;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.security.password.Credential;
import com.google.common.base.Objects;
import com.opensymphony.module.propertyset.PropertySet;
import com.resolution.atlasplugins.samlsso.confluence.UserModificator;
import com.resolution.atlasplugins.samlsso.confluence.UserModificatorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserModificatorImpl
implements UserModificator {
    private static final Logger logger = LoggerFactory.getLogger(UserModificatorImpl.class);
    private final UserAccessor userAccessor;

    public UserModificatorImpl(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Override
    public ConfluenceUser createUser(String username, String displayName, String emailAddress) throws UserModificatorException {
        this.impersonateExecutionUser();
        DefaultUser newDefaultUser = new DefaultUser();
        newDefaultUser.setName(username);
        newDefaultUser.setFullName(displayName);
        newDefaultUser.setEmail(emailAddress);
        ConfluenceUser newUser = this.userAccessor.createUser((User)newDefaultUser, Credential.NONE);
        PropertySet userProperties = this.userAccessor.getPropertySet(newUser);
        userProperties.setBoolean("createdFromSAMLSingleSignOn", true);
        this.userAccessor.saveUser((User)newUser);
        return newUser;
    }

    @Override
    public boolean updateUser(ConfluenceUser appUser, String newFullName, String newEmailAddress) throws UserModificatorException {
        this.impersonateExecutionUser();
        boolean changed = false;
        DefaultUser templateUser = new DefaultUser((User)appUser);
        if (newFullName != null && !Objects.equal((Object)appUser.getFullName(), (Object)newFullName)) {
            changed = true;
            templateUser.setFullName(newFullName);
        }
        if (newEmailAddress != null && !Objects.equal((Object)appUser.getEmail(), (Object)newEmailAddress)) {
            changed = true;
            templateUser.setEmail(newEmailAddress);
        }
        if (changed) {
            this.userAccessor.saveUser((User)templateUser);
        }
        return changed;
    }

    @Override
    public boolean updateUserGroups(ConfluenceUser appUser, Collection<String> groups, boolean remove) throws UserModificatorException {
        Group group;
        this.impersonateExecutionUser();
        List currentGroups = this.userAccessor.getGroupNames((User)appUser);
        ArrayList<String> groupsToRemove = new ArrayList<String>();
        ArrayList<String> groupsToAdd = new ArrayList<String>();
        if (remove) {
            for (String currentGroup : currentGroups) {
                if (groups.contains(currentGroup)) continue;
                groupsToRemove.add(currentGroup);
            }
        }
        for (String groupToAdd : groups) {
            if (currentGroups.contains(groupToAdd)) continue;
            groupsToAdd.add(groupToAdd);
        }
        if (groupsToAdd.isEmpty() && groupsToRemove.isEmpty()) {
            return false;
        }
        for (String groupName : groupsToAdd) {
            group = this.userAccessor.getGroup(groupName);
            if (group != null) {
                this.userAccessor.addMembership(group, (User)appUser);
                continue;
            }
            logger.warn("Group {} does not exist.", (Object)groupName);
        }
        for (String groupName : groupsToRemove) {
            group = this.userAccessor.getGroup(groupName);
            if (group != null) {
                this.userAccessor.removeMembership(group, (User)appUser);
                continue;
            }
            logger.warn("Group {} does not exist.", (Object)groupName);
        }
        return true;
    }

    @Override
    public boolean enableUser(ConfluenceUser appUser) throws UserModificatorException {
        this.impersonateExecutionUser();
        if (this.userAccessor.isDeactivated((User)appUser)) {
            this.userAccessor.reactivateUser((User)appUser);
            return true;
        }
        return false;
    }

    @Override
    public boolean disableUser(ConfluenceUser appUser) throws UserModificatorException {
        this.impersonateExecutionUser();
        if (!this.userAccessor.isDeactivated((User)appUser)) {
            this.userAccessor.deactivateUser((User)appUser);
            return true;
        }
        return false;
    }

    private void impersonateExecutionUser() {
        Group adminGroup = this.userAccessor.getGroup("confluence-administrators");
        Iterable adminUsers = this.userAccessor.getMembers(adminGroup);
        ConfluenceUser user = null;
        Iterator it = adminUsers.iterator();
        if (it.hasNext()) {
            user = (ConfluenceUser)it.next();
            logger.debug("Impersonating admin user {}.", (Object)user.getName());
            AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
        } else {
            logger.error("No admin user found, not impersonating.");
        }
    }

    @Override
    public boolean isSAMLCreated(ConfluenceUser appUser) {
        PropertySet userProperties = this.userAccessor.getPropertySet(appUser);
        return userProperties.getBoolean("createdFromSAMLSingleSignOn");
    }
}

