/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.confluence;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.resolution.atlasplugins.samlsso.AbstractSamlSsoService;
import com.resolution.atlasplugins.samlsso.AuthenticatorHook;
import com.resolution.atlasplugins.samlsso.UserPreparationException;
import com.resolution.atlasplugins.samlsso.cluster.ClusterNotificator;
import com.resolution.atlasplugins.samlsso.configuration.PluginConfiguration;
import com.resolution.atlasplugins.samlsso.confluence.UserModificator;
import com.resolution.atlasplugins.samlsso.confluence.UserModificatorException;
import com.resolution.samlprocessor.SAMLResponseContent;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceSamlSsoService
extends AbstractSamlSsoService {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceSamlSsoService.class);
    private final UserModificator userModificator;
    private final UserAccessor userAccessor;

    public ConfluenceSamlSsoService(PluginConfiguration pluginConfiguration, ApplicationProperties applicationProperties, TransactionTemplate transactionTemplate, EventPublisher eventPublisher, CrowdService crowdService, CrowdDirectoryService crowdDirectorySerivce, AuthenticatorHook authenticatorHook, ClusterNotificator clusterNotificator, UserModificator userModificator, UserAccessor userAccessor) {
        super(pluginConfiguration, applicationProperties, eventPublisher, crowdService, crowdDirectorySerivce, authenticatorHook, clusterNotificator);
        this.userModificator = userModificator;
        this.userAccessor = userAccessor;
    }

    @Override
    public String getLoginPageUrl() {
        return this.getRelativeBaseUrl() + "/login.action?nosso";
    }

    @Override
    public String getAbsoluteLoginPageUrl() {
        return this.getAbsoluteBaseUrl() + "/login.action?nosso";
    }

    @Override
    public String getRedirectUrlForLogin(HttpServletRequest request) {
        return super.getRedirectUrlForLogin(request, "/login.action");
    }

    @Override
    public String getRedirectUrlForLogout(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        if (servletPath.equals("/login.action") && request.getParameter("logout") != null && request.getParameter("logout").equals(true)) {
            return "/plugins/servlet/samlsso/logout";
        }
        if (servletPath.equals("/logout.action")) {
            return this.getRelativeBaseUrl() + "/plugins/servlet/samlsso/logout";
        }
        return null;
    }

    @Override
    public boolean prepareUser(SAMLResponseContent samlResponseContent, boolean updateGroups, boolean sdCustomer) throws UserPreparationException {
        if (samlResponseContent.isUpdateUser()) {
            boolean addedOrUpdated = false;
            String userid = samlResponseContent.getUserid();
            ConfluenceUser appUser = null;
            if (this.userAccessor.exists(userid)) {
                appUser = this.userAccessor.getUserByName(userid);
            }
            if (appUser == null) {
                logger.info("Creating user {}", (Object)userid);
                updateGroups = updateGroups;
                try {
                    appUser = this.userModificator.createUser(userid, samlResponseContent.getFullName(), samlResponseContent.getEmailAddress());
                    addedOrUpdated = true;
                }
                catch (UserModificatorException e) {
                    throw new UserPreparationException(e);
                }
            }
            try {
                if (samlResponseContent.isUpdateExisting() || this.userModificator.isSAMLCreated(appUser)) {
                    addedOrUpdated = this.userModificator.updateUser(appUser, samlResponseContent.getFullName(), samlResponseContent.getEmailAddress());
                    updateGroups = updateGroups;
                } else {
                    logger.debug("This user is not created by us and updating existing users is not enabled, not changing users");
                    updateGroups = false;
                }
            }
            catch (UserModificatorException e) {
                throw new UserPreparationException(e);
            }
            if (updateGroups) {
                boolean removeGroups = samlResponseContent.isRemoveFromGroups() && this.userModificator.isSAMLCreated(appUser);
                HashSet<String> groupSet = new HashSet<String>();
                groupSet.addAll(this.pluginConfiguration.getGroupsToAddUserToList());
                groupSet.addAll(samlResponseContent.getGroups());
                try {
                    boolean groupsChanged = this.userModificator.updateUserGroups(appUser, groupSet, removeGroups);
                    addedOrUpdated = addedOrUpdated || groupsChanged;
                }
                catch (UserModificatorException e) {
                    throw new UserPreparationException(e);
                }
            } else {
                logger.debug("updateGroups is false, not updating user groups");
            }
            return addedOrUpdated;
        }
        logger.debug("User update is not enabled");
        return false;
    }

    @Override
    public boolean isConfluence() {
        return true;
    }
}

