/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.confluence;

import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.directory.DelegatedAuthenticationDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.atlassianuser.EmbeddedCrowdUser;
import com.atlassian.crowd.event.user.UserAuthenticatedEvent;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.resolution.atlasplugins.samlsso.AbstractAuthenticatorHook;
import com.resolution.atlasplugins.samlsso.AuthenticatorHookException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceAuthenticatorHook
extends AbstractAuthenticatorHook {
    private final Logger logger = LoggerFactory.getLogger(ConfluenceAuthenticatorHook.class);
    private DefaultAuthenticator authenticator;
    private TransactionTemplate transactionTemplate;
    private LoginManager loginManager;
    private ApplicationService applicationService;
    private ApplicationDAO applicationDao;
    private DirectoryInstanceLoader directoryLoader;
    private EventPublisher eventPublisher;

    public ConfluenceAuthenticatorHook(TransactionTemplate transactionTemplate, LoginManager loginManager) throws AuthenticatorHookException {
        this.logger.debug("Creating ConfluenceAuthenticatorHook...");
        this.transactionTemplate = transactionTemplate;
        this.loginManager = loginManager;
        Authenticator originalAuthenticator = SecurityConfigFactory.getInstance().getAuthenticator();
        if (!(originalAuthenticator instanceof DefaultAuthenticator)) {
            throw new AuthenticatorHookException("This authenticator of type " + this.authenticator.getClass().getCanonicalName() + "is not a DefaultAuthenticator.");
        }
        this.authenticator = (DefaultAuthenticator)originalAuthenticator;
    }

    @Override
    public boolean isLoggedInUser() {
        return AuthenticatedUserThreadLocal.get() != null;
    }

    @Override
    public boolean doAuthoriseUserAndEstablishSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String userid) throws AuthenticatorHookException {
        Class<DefaultAuthenticator> authenticatorClass = DefaultAuthenticator.class;
        Principal principal = this.getUser(userid);
        if (principal == null) {
            this.logger.debug("User " + userid + " was not found.");
            return false;
        }
        this.logger.debug("Principal name is: " + principal.getName() + ", class is: " + principal.getClass().getCanonicalName());
        try {
            String DIRECT_LOGIN = "com.atlassian.confluence.login.direct";
            httpServletRequest.setAttribute("com.atlassian.confluence.login.direct", (Object)true);
            String methodName = "authoriseUserAndEstablishSession";
            Class[] parameterTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class, Principal.class};
            Object[] parameters = new Object[]{httpServletRequest, httpServletResponse, principal};
            Method methodToInvoke = authenticatorClass.getDeclaredMethod(methodName, parameterTypes);
            methodToInvoke.setAccessible(true);
            Object returnValue = methodToInvoke.invoke((Object)this.authenticator, parameters);
            if (returnValue instanceof Boolean) {
                boolean authenticated = (Boolean)returnValue;
                this.logger.debug("authoriseUserAndEstablishSession returned " + authenticated);
                if (authenticated) {
                    this.loginManager.onSuccessfulLoginAttempt(userid, httpServletRequest);
                }
                return authenticated;
            }
            throw new AuthenticatorHookException("Authenticator method did not return a boolean, but a " + returnValue.getClass().getCanonicalName());
        }
        catch (SecurityException e) {
            throw new AuthenticatorHookException(e);
        }
        catch (NoSuchMethodException e) {
            throw new AuthenticatorHookException(e);
        }
        catch (IllegalArgumentException e) {
            throw new AuthenticatorHookException(e);
        }
        catch (IllegalAccessException e) {
            throw new AuthenticatorHookException(e);
        }
        catch (InvocationTargetException e) {
            throw new AuthenticatorHookException(e.getCause());
        }
    }

    protected Principal getUser(String userid) throws AuthenticatorHookException {
        Object principal = null;
        principal = this.findLdapUser(userid);
        if (principal == null) {
            Class<DefaultAuthenticator> authenticatorClass = DefaultAuthenticator.class;
            Class[] paramTypes = new Class[]{String.class};
            Object[] params = new Object[]{userid};
            try {
                Method getUserMethod = authenticatorClass.getDeclaredMethod("getUser", paramTypes);
                getUserMethod.setAccessible(true);
                Object userObject = getUserMethod.invoke((Object)this.authenticator, params);
                if (userObject == null) {
                    return null;
                }
                if (!(userObject instanceof Principal)) {
                    throw new AuthenticatorHookException("getUser method did not return a Principal but a " + userObject.getClass().getCanonicalName());
                }
                principal = (Principal)userObject;
            }
            catch (SecurityException e) {
                throw new AuthenticatorHookException(e);
            }
            catch (NoSuchMethodException e) {
                throw new AuthenticatorHookException(e);
            }
            catch (IllegalArgumentException e) {
                throw new AuthenticatorHookException(e);
            }
            catch (IllegalAccessException e) {
                throw new AuthenticatorHookException(e);
            }
            catch (InvocationTargetException e) {
                throw new AuthenticatorHookException(e.getCause());
            }
        }
        return principal;
    }

    protected User findLdapUser(final String username) {
        return (User)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<User>(){

            public User doInTransaction() {
                Application application;
                try {
                    application = ConfluenceAuthenticatorHook.this.getApplicationDao().findByName("crowd-embedded");
                }
                catch (ApplicationNotFoundException e) {
                    ConfluenceAuthenticatorHook.this.logger.error(String.format("Unable to load Application singleton %s: %s", e.getMessage(), e.toString()));
                    return null;
                }
                Iterable activeDirectories = ConfluenceAuthenticatorHook.this.getActiveLdapDirectories(application);
                for (Directory dir : activeDirectories) {
                    try {
                        com.atlassian.crowd.model.user.User crowdUser;
                        ConfluenceAuthenticatorHook.this.logger.debug(String.format("Enumerating directory %s (%s): %s", String.valueOf(dir.getId()), dir.getName(), dir.getDescription()));
                        ConfluenceAuthenticatorHook.this.logger.debug(String.format("The directory is of type %s", dir.getType().toString()));
                        RemoteDirectory remoteDir = ConfluenceAuthenticatorHook.this.getDirectoryLoader().getDirectory(dir);
                        if (remoteDir instanceof DelegatedAuthenticationDirectory) {
                            ConfluenceAuthenticatorHook.this.logger.debug("Forcing optional 'Copy User on Login' and 'Group Import' processing.");
                            crowdUser = ((DelegatedAuthenticationDirectory)remoteDir).addOrUpdateLdapUser(username);
                        } else {
                            ConfluenceAuthenticatorHook.this.logger.debug("Locating user in directory");
                            crowdUser = remoteDir.findUserByName(username);
                        }
                        ConfluenceAuthenticatorHook.this.triggerUserAuthenticatedEvent(application, dir, crowdUser);
                        return new EmbeddedCrowdUser((User)crowdUser);
                    }
                    catch (DirectoryInstantiationException e) {
                        ConfluenceAuthenticatorHook.this.logger.error(String.format("Unable to instantiate the desired RemoteDirectory; skipping (%s: %s)", e.getMessage(), e.toString()));
                    }
                    catch (UserNotFoundException e) {
                        ConfluenceAuthenticatorHook.this.logger.debug("User not {} found in this directory; skipping.", (Object)username);
                    }
                    catch (OperationFailedException e) {
                        ConfluenceAuthenticatorHook.this.logger.error(String.format("Failed to check directory for user; skipping (%s: %s)", e.getMessage(), e.toString()));
                    }
                }
                ConfluenceAuthenticatorHook.this.logger.info("The requested username does not appear to be a valid user in any configured LDAP directory.");
                return null;
            }
        });
    }

    private void triggerUserAuthenticatedEvent(Application application, Directory directory, com.atlassian.crowd.model.user.User user) {
        this.logger.debug(String.format("Firing UserAuthenticatedEvent for User %s in Directory %s", user.getName(), directory.getName()));
        this.getEventPublisher().publish((Object)new UserAuthenticatedEvent((Object)this.getApplicationService(), directory, application, user));
    }

    private ApplicationService getApplicationService() {
        if (this.applicationService == null) {
            this.applicationService = (ApplicationService)ContainerManager.getComponent((String)"crowdApplicationService");
        }
        return this.applicationService;
    }

    private ApplicationDAO getApplicationDao() {
        if (this.applicationDao == null) {
            this.applicationDao = (ApplicationDAO)ContainerManager.getComponent((String)"embeddedCrowdApplicationDao");
        }
        return this.applicationDao;
    }

    private Iterable<Directory> getActiveLdapDirectories(Application application) {
        return Iterables.filter((Iterable)Iterables.transform((Iterable)application.getDirectoryMappings(), (Function)new Function<DirectoryMapping, Directory>(){

            public Directory apply(DirectoryMapping from) {
                return from.getDirectory();
            }
        }), (Predicate)new Predicate<Directory>(){

            public boolean apply(Directory from) {
                return from.isActive() && (from.getType().equals((Object)DirectoryType.DELEGATING) || from.getType().equals((Object)DirectoryType.CONNECTOR));
            }
        });
    }

    private DirectoryInstanceLoader getDirectoryLoader() {
        if (this.directoryLoader == null) {
            this.directoryLoader = (DirectoryInstanceLoader)ContainerManager.getComponent((String)"directoryInstanceLoader");
        }
        return this.directoryLoader;
    }

    protected EventPublisher getEventPublisher() {
        if (this.eventPublisher == null) {
            this.eventPublisher = (EventPublisher)ContainerManager.getInstance().getContainerContext().getComponent((Object)"eventPublisher");
        }
        return this.eventPublisher;
    }

    @Override
    protected DefaultAuthenticator getAuthenticator() {
        return this.authenticator;
    }
}

