/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.PluginConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.UpdateConfigurationResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class PluginConfigurationRestResource {
    private static final Logger logger = LoggerFactory.getLogger(PluginConfigurationRestResource.class);
    private final UserManager userManager;
    private final TransactionTemplate transactionTemplate;
    private final PluginConfiguration pluginConfiguration;

    public PluginConfigurationRestResource(PluginConfiguration pluginConfiguration, UserManager userManager, TransactionTemplate transactionTemplate) {
        logger.debug("Constructing PluginConfigurationRestResource");
        this.pluginConfiguration = pluginConfiguration;
        this.userManager = userManager;
        this.transactionTemplate = transactionTemplate;
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response getConfig(@Context HttpServletRequest request) {
        UserProfile userProfile = this.userManager.getRemoteUser(request);
        if (userProfile == null || !this.userManager.isSystemAdmin(userProfile.getUserKey())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        return Response.ok((Object)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<ConfigurationData>(){

            public ConfigurationData doInTransaction() {
                ConfigurationData ret = PluginConfigurationRestResource.this.pluginConfiguration.getConfigurationData();
                return ret;
            }
        })).cacheControl(cacheControl).build();
    }

    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response updateConfig(final ConfigurationData config, @Context HttpServletRequest request) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        UserProfile userProfile = this.userManager.getRemoteUser(request);
        if (userProfile == null || !this.userManager.isSystemAdmin(userProfile.getUserKey())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(cacheControl).build();
        }
        List<String> validationMessages = this.pluginConfiguration.validate(config);
        if (validationMessages.isEmpty()) {
            Boolean updateResult = (Boolean)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

                public Boolean doInTransaction() {
                    return PluginConfigurationRestResource.this.pluginConfiguration.update(config);
                }
            });
            if (updateResult.booleanValue()) {
                return Response.ok().entity((Object)new UpdateConfigurationResponse(true, validationMessages, config)).cacheControl(cacheControl).build();
            }
            validationMessages.add("Updating configuration failed, check logfiles for more details.");
            return Response.ok().entity((Object)new UpdateConfigurationResponse(false, validationMessages, config)).build();
        }
        return Response.ok().entity((Object)new UpdateConfigurationResponse(false, validationMessages, config)).cacheControl(cacheControl).build();
    }
}

