/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.resolution.atlasplugins.samlsso.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
public class IdpConfiguration
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(IdpConfiguration.class);
    private Integer id = null;
    private String name;
    private String description;
    private String url;
    private String issuer;
    private String certificate;
    private String secondCertificate;
    private String relayStateParameterName;
    private String ssoUrl = null;
    private String useridAttribute = null;
    private String fullnameAttribute = null;
    private String emailAttribute = null;
    private String groupAttribute = null;
    private String groupsForNewUsers = null;
    private String groupsForNewSdCustomers = null;
    private String emailDomains = null;
    private String useridTransformationRegex;
    private String useridTransformationReplacement;
    private Long directoryIdForNewUsers;
    private boolean omitRequestedAuthnContext = true;
    private boolean removeFromGroups = false;
    private boolean updateExisting = false;
    private boolean enableUserUpdate = false;
    private boolean lowercaseConvert = false;
    private boolean lowercaseConvertGroups = false;
    private String metadataurl;
    private String metadataxml;
    private boolean metadataignorecert;
    private boolean useMetadataxml = false;
    private HashMap<String, String> idpAttributes = new HashMap();

    @XmlElementWrapper(name="idpAttributes")
    public Map<String, String> getIdpAttributes() {
        return this.idpAttributes;
    }

    public void setIdpAttributes(HashMap<String, String> idpAttributes) {
        this.idpAttributes = idpAttributes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public String getSecondCertificate() {
        return this.secondCertificate;
    }

    public void setSecondCertificate(String secondCertificate) {
        this.secondCertificate = secondCertificate;
    }

    public String getRelayStateParameterName() {
        return this.relayStateParameterName;
    }

    public void setRelayStateParameterName(String relayStateParameterName) {
        this.relayStateParameterName = relayStateParameterName;
    }

    public String getUseridTransformationRegex() {
        return this.useridTransformationRegex;
    }

    public void setUseridTransformationRegex(String useridTransformationRegex) {
        this.useridTransformationRegex = useridTransformationRegex;
    }

    public String getUseridTransformationReplacement() {
        return this.useridTransformationReplacement;
    }

    public void setUseridTransformationReplacement(String useridTransformationReplacement) {
        this.useridTransformationReplacement = useridTransformationReplacement;
    }

    public boolean isOmitRequestedAuthnContext() {
        return this.omitRequestedAuthnContext;
    }

    public void setOmitRequestedAuthnContext(boolean omitRequestedAuthnContext) {
        this.omitRequestedAuthnContext = omitRequestedAuthnContext;
    }

    public boolean isEnableUserUpdate() {
        return this.enableUserUpdate;
    }

    public void setEnableUserUpdate(boolean enableUserUpdate) {
        this.enableUserUpdate = enableUserUpdate;
    }

    public boolean isLowercaseConvert() {
        return this.lowercaseConvert;
    }

    public void setLowercaseConvert(boolean lowercaseConvert) {
        this.lowercaseConvert = lowercaseConvert;
    }

    public boolean isLowercaseConvertGroups() {
        return this.lowercaseConvertGroups;
    }

    public void setLowercaseConvertGroups(boolean lowercaseConvertGroups) {
        this.lowercaseConvertGroups = lowercaseConvertGroups;
    }

    public boolean isRemoveFromGroups() {
        return this.removeFromGroups;
    }

    public void setRemoveFromGroups(boolean removeFromGroups) {
        this.removeFromGroups = removeFromGroups;
    }

    public boolean isUpdateExisting() {
        return this.updateExisting;
    }

    public void setUpdateExisting(boolean updateExisting) {
        this.updateExisting = updateExisting;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getMetadataurl() {
        return this.metadataurl;
    }

    public void setMetadataurl(String metadataurl) {
        this.metadataurl = metadataurl;
    }

    public boolean isMetadataignorecert() {
        return this.metadataignorecert;
    }

    public void setMetadataignorecert(boolean metadataignorecert) {
        this.metadataignorecert = metadataignorecert;
    }

    public String getMetadataxml() {
        return this.metadataxml;
    }

    public void setMetadataxml(String metadataxml) {
        this.metadataxml = metadataxml;
    }

    public boolean isUseMetadataxml() {
        return this.useMetadataxml;
    }

    public void setUseMetadataxml(boolean useMetadataxml) {
        this.useMetadataxml = useMetadataxml;
    }

    public String getSsoUrl() {
        return this.ssoUrl;
    }

    public String getUseridAttribute() {
        return this.useridAttribute;
    }

    public void setUseridAttribute(String useridAttribute) {
        this.useridAttribute = useridAttribute;
    }

    public String getFullnameAttribute() {
        return this.fullnameAttribute;
    }

    public void setFullnameAttribute(String fullnameAttribute) {
        this.fullnameAttribute = fullnameAttribute;
    }

    public String getEmailAttribute() {
        return this.emailAttribute;
    }

    public void setEmailAttribute(String emailAttribute) {
        this.emailAttribute = emailAttribute;
    }

    public String getGroupAttribute() {
        return this.groupAttribute;
    }

    public void setGroupAttribute(String groupAttribute) {
        this.groupAttribute = groupAttribute;
    }

    public String getGroupsForNewUsers() {
        return this.groupsForNewUsers;
    }

    public List<String> getGroupsForNewUsersList() {
        return Utils.splitString(this.getGroupsForNewUsers());
    }

    public void setGroupsForNewUsers(String groupsForNewUsers) {
        this.groupsForNewUsers = groupsForNewUsers;
    }

    public String getGroupsForNewSdCustomers() {
        return this.groupsForNewSdCustomers;
    }

    public List<String> getGroupsForNewSdCustomersList() {
        return Utils.splitString(this.getGroupsForNewSdCustomers());
    }

    public void setGroupsForNewSdCustomers(String groupsForNewSdCustomers) {
        this.groupsForNewSdCustomers = groupsForNewSdCustomers;
    }

    public Long getDirectoryIdForNewUsers() {
        return this.directoryIdForNewUsers;
    }

    public void setDirectoryIdForNewUsers(Long directoryIdForNewUsers) {
        this.directoryIdForNewUsers = directoryIdForNewUsers;
    }

    public String getEmailDomains() {
        return this.emailDomains;
    }

    public List<String> getEmailDomainsList() {
        return Utils.splitString(this.getEmailDomains());
    }

    public void setEmailDomains(String emailDomains) {
        this.emailDomains = emailDomains;
    }

    @XmlTransient
    public void setSsoUrl(String ssoUrl) {
        this.ssoUrl = ssoUrl;
    }

    public boolean equals(Object otherObject) {
        if (otherObject == null) {
            return false;
        }
        if (!(otherObject instanceof IdpConfiguration)) {
            return false;
        }
        IdpConfiguration other = (IdpConfiguration)otherObject;
        Field[] fields = this.getClass().getDeclaredFields();
        try {
            for (int i = 0; i < fields.length; ++i) {
                Object thisField = fields[i].get(this);
                Object otherField = fields[i].get(other);
                if (thisField == null && otherField != null) {
                    logger.debug("{} differs", (Object)fields[i].getName());
                    return false;
                }
                if (thisField != null && otherField == null) {
                    logger.debug("{} differs", (Object)fields[i].getName());
                    return false;
                }
                if (thisField == null || otherField == null || thisField.equals(otherField)) continue;
                logger.debug("{} differs", (Object)fields[i].getName());
                return false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public IdpConfiguration clone() {
        try {
            IdpConfiguration ret = new IdpConfiguration();
            Field[] fields = this.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (Modifier.isStatic(fields[i].getModifiers())) continue;
                fields[i].set(ret, fields[i].get(this));
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

