/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.resolution.atlasplugins.samlsso.configuration.CertificateCheck;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.IdpConfiguration;
import com.resolution.samlprocessor.FieldCombiner;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationValidator {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationValidator.class);
    public static final String MSG_IDP_REQUIRED = "At least one Identity provider must be configured";
    public static final String MSG_URL_WRONG = "IdP URL does not start with http";
    public static final String MSG_NO_NAME = "IdP name must be set";
    public static final String MSG_CERT_INVALID = "Certificate invalid: ";
    public static final String MSG_2ND_CERT_INVALID = "Second Certificate invalid: ";
    public static final String MSG_ISSUER_REQUIRED = "Issuer must be set if more than one IdP is configured";
    public static final String MSG_GROUP_FOR_ENABLEMENT_REQUIRED = "A user group must be specified if Enable user for Service Desk login is active";

    public List<String> validate(ConfigurationData configurationData) {
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (configurationData.idpConfigurations == null || configurationData.idpConfigurations.isEmpty()) {
            logger.debug(MSG_IDP_REQUIRED);
            validationMessages.add(MSG_IDP_REQUIRED);
        } else {
            int idpCount = configurationData.idpConfigurations.size();
            HashSet<String> emailDomains = new HashSet<String>();
            for (IdpConfiguration idpConfig : configurationData.idpConfigurations) {
                String idpName;
                List<String> idpValidationResult = this.validate(idpConfig);
                if (idpCount > 1 && (idpConfig.getIssuer() == null || idpConfig.getIssuer().trim().isEmpty())) {
                    idpValidationResult.add(MSG_ISSUER_REQUIRED);
                }
                for (String idpMessage : idpValidationResult) {
                    idpName = idpConfig.getName();
                    if (idpName == null || idpName.trim().isEmpty()) {
                        idpName = "new IdP";
                    }
                    validationMessages.add(idpName + ": " + idpMessage);
                }
                for (String emailDomain : idpConfig.getEmailDomainsList()) {
                    idpName = idpConfig.getName();
                    if (emailDomains.contains(emailDomain)) {
                        validationMessages.add(idpName + ": E-Mail-Domain '" + emailDomain + "' is not unique.");
                        continue;
                    }
                    emailDomains.add(emailDomain);
                }
            }
        }
        if (configurationData.clockSkew < 0) {
            validationMessages.add("Clock skew must be > 0");
        }
        return validationMessages;
    }

    public List<String> validate(IdpConfiguration idpConfig) {
        CertificateCheck secondCertCheck;
        CertificateCheck certCheck;
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (idpConfig.getUrl() == null || !idpConfig.getUrl().startsWith("http")) {
            logger.debug(MSG_URL_WRONG);
            validationMessages.add(MSG_URL_WRONG);
        }
        if (idpConfig.getName() == null || idpConfig.getName().trim().isEmpty()) {
            logger.debug(MSG_NO_NAME);
            validationMessages.add(MSG_NO_NAME);
        }
        if ((certCheck = new CertificateCheck(idpConfig.getCertificate())).isCertSet() && !certCheck.isValid()) {
            validationMessages.add(MSG_CERT_INVALID + certCheck.getReadable());
        }
        if ((secondCertCheck = new CertificateCheck(idpConfig.getSecondCertificate())).isCertSet() && !secondCertCheck.isValid()) {
            validationMessages.add(MSG_2ND_CERT_INVALID + secondCertCheck.getReadable());
        }
        try {
            FieldCombiner.testString(idpConfig.getFullnameAttribute());
        }
        catch (ParseException e) {
            validationMessages.add("IdP " + idpConfig.getId() + " full name: " + e.getMessage());
        }
        try {
            FieldCombiner.testString(idpConfig.getEmailAttribute());
        }
        catch (ParseException e) {
            validationMessages.add("IdP " + idpConfig.getId() + " email: " + e.getMessage());
        }
        return validationMessages;
    }
}

