/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.IdpConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurationMigrator {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationMigrator.class);
    public static final String DEFAULT_IDPNAME = "IDP";
    private PluginSettings pluginSettings;

    public abstract ConfigurationData migrateSpecific(ConfigurationData var1);

    public ConfigurationData migrate(PluginSettings pluginSettings, ConfigurationData configData) {
        String cert;
        String tpl;
        String agt;
        String logoutUrl;
        IdpConfiguration idpConfig;
        this.pluginSettings = pluginSettings;
        logger.info("Migrating Configuration...");
        if (configData.idpConfigurations.isEmpty()) {
            logger.info("Creating new IdP configuration");
            idpConfig = new IdpConfiguration();
            idpConfig.setId(1);
            configData.idpConfigurations.add(idpConfig);
        } else {
            logger.warn("There is already a Idp Configuration. This is not expected. Data will be overwritten.");
            idpConfig = configData.idpConfigurations.get(0);
        }
        if (idpConfig.getName() == null) {
            logger.info("Setting IdP name {}", (Object)DEFAULT_IDPNAME);
            idpConfig.setName(DEFAULT_IDPNAME);
        }
        if (this.has("idpUrl")) {
            String idpUrl = this.get("idpUrl");
            logger.info("Setting first IdP URL to {}", (Object)idpUrl);
            idpConfig.setUrl(idpUrl);
        }
        if (this.has("relayStateParameterName")) {
            String rl = this.get("relayStateParameterName");
            if (!rl.equals("RelayState")) {
                logger.info("Setting default RelayState parameter name to {}", (Object)rl);
            }
            idpConfig.setRelayStateParameterName(rl);
        }
        if (this.has("useridTransformationRegex")) {
            String regex = this.get("useridTransformationRegex");
            logger.info("Setting useridTransformationRegex to {}", (Object)regex);
            idpConfig.setUseridTransformationRegex(regex);
        }
        if (this.has("useridTransformationReplacement")) {
            String repl = this.get("useridTransformationReplacement");
            logger.info("Setting useridTransformationReplacement to {}", (Object)repl);
            idpConfig.setUseridTransformationReplacement(repl);
        }
        if (this.has("setLoginUrl")) {
            logger.info("Enabling login URL overide");
            configData.overrideLoginUrl = true;
        }
        if (this.has("overrideLogOutURL")) {
            logger.info("Enabling logout URL overide");
            configData.overrideLogoutUrl = true;
        }
        if (this.has("redirectDashboardURL")) {
            logger.info("Enabling dashboard URL redirection");
            configData.redirectDashboardUrl = true;
        }
        if (this.has("enableUserForLogin")) {
            logger.info("Enabling login enablement for Service Desk users");
            configData.enableUserForLogin = true;
        }
        if (this.has("redirectWithPOST")) {
            logger.info("Enabling redirect with POST");
            configData.redirectWithPOST = true;
        }
        if (this.has("omitRequestedAuthnContext")) {
            logger.info("Enabling omitRequestedAuthnContext");
            idpConfig.setOmitRequestedAuthnContext(true);
        }
        if (this.has("logoutUrl") && !(logoutUrl = this.get("logoutUrl")).equals("/plugins/servlet/samlsso/logout")) {
            logger.info("Setting logout URL to {}", (Object)logoutUrl);
            configData.logoutUrl = logoutUrl;
        }
        if (this.has("defaultRedirectUrl")) {
            String url = this.get("defaultRedirectUrl");
            if (!url.equals("/")) {
                logger.info("Setting default redirect URL to {}", (Object)url);
            }
            configData.defaultRedirectUrl = url;
        }
        if (this.has("groupsToAddUserTo")) {
            String groups = this.get("groupsToAddUserTo");
            logger.info("Setting groups to {}", (Object)groups);
            configData.groupsToAddUserTo = groups;
        }
        if (this.has("nonSsoUserAgents") && !(agt = this.get("nonSsoUserAgents")).equals("Jakarta Commons-HttpClient")) {
            logger.info("Setting nonsso-useragents to {}", (Object)agt);
            configData.nonSsoUserAgents = agt;
        }
        if (this.has("nonSsoDestinations") && !(agt = this.get("nonSsoDestinations")).equals("%2Fplugins%2Fservlet%2Fapplinks,applicationlinks")) {
            logger.info("Setting nonsso-destinations to {}", (Object)agt);
            configData.nonSsoDestinations = agt;
        }
        if (this.has("licenseString")) {
            String licenseString = this.get("licenseString");
            logger.info("Setting license to {}", (Object)licenseString);
            configData.licenseString = licenseString;
        }
        if (this.has("errorPageTemplate") && !(tpl = this.get("errorPageTemplate")).equals("<html>\n <head>\n  <title>SAML Single Sign On failed</title>\n  $webResourceManager.requireResource(\"$pluginproperties.pluginkey:resources\")\n  <meta name=\"decorator\" content=\"atl.general\">\n </head>\n  <body class=\"aui-page-focused aui-page-medium\" >\n   <div class=\"aui-page-panel\">\n    <div class=\"aui-page-panel-inner\">\n     <section class=\"aui-page-panel-content\">\n      <h1>SAML Single Sign On failed</h1>\n      <div>Please contact your administrator or log in at the <a href=\"$loginurl\">login page</a>.</div>\n      #if($userid)\n       <div class=\"aui-message error\">$userid could not be authorized. This userid is unknown or the user does not have sufficient permissions.</div>\n      #end\n      #if($message)\n       <div class=\"aui-message error\">$message</div>\n      #end\n      #if($stacktrace)\n      <a id=\"show-stacktrace-trigger\" data-replace-text=\"Hide Stack Trace\" class=\"aui-expander-trigger button\" aria-controls=\"stacktrace\">Show Stack Trace</a>\n      <div class=\"aui-expander-content\" id=\"stacktrace\">$stacktrace</div>\n      #end\n     </section>\n    </div>\n   </div>\n </body>\n</html>")) {
            logger.info("Setting error page template to {}", (Object)tpl);
            configData.errorPageTemplate = tpl;
        }
        if (this.has("loggedOutPageTemplate") && !(tpl = this.get("loggedOutPageTemplate")).equals("<html>\n <head>\n  <title>You are logged out now</title>\n  $webResourceManager.requireResource(\"$pluginproperties.pluginkey:resources\")\n  <meta name=\"decorator\" content=\"atl.general\">\n </head>\n <body class=\"aui-layout aui-theme-default page-type-message\" >\n  <section id=\"content\" role=\"main\">\n   <div class=\"aui-page-panel\"><div class=\"aui-page-panel-inner\">\n    <section class=\"aui-page-panel-content\">\n     <div class=\"form-body\">\n     <div class=\"aui-message info\"><span class=\"aui-icon icon-info\"></span><p class=\"title\">\n      <strong>You are logged out now</strong></p>\n      <p>\n       <a href=\"$loginurl\">Login again with username and password</a>\n      </p>\n      <p>\n       <a href=\"$ssourl\">Login again with Single Sign On</a>  \n      </p>\n     </div>\n    </div>\n   </section>\n  </div>\n </div>\n</section>\n</body>\n</html>")) {
            logger.info("Setting logged out page template to {}", (Object)tpl);
            configData.loggedOutPageTemplate = tpl;
        }
        if (this.has("base64encodedCertificate")) {
            cert = this.get("base64encodedCertificate");
            logger.info("Setting cetificate to {}", (Object)cert);
            idpConfig.setCertificate(cert);
        }
        if (!this.has("base64encodedCertificate") && this.has("base64encodedIdPCertificate")) {
            cert = this.get("base64encodedIdPCertificate");
            logger.info("Setting cetificate from key base64encodedIdPCertificate to {}", (Object)cert);
            idpConfig.setCertificate(cert);
        }
        return this.migrateSpecific(configData);
    }

    private boolean has(String key) {
        return this.pluginSettings.get("com.resolution.atlasplugins.samlsso:" + key) != null;
    }

    private String get(String key) {
        return (String)this.pluginSettings.get("com.resolution.atlasplugins.samlsso:" + key);
    }
}

