/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.IdpConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationDefaultSetter {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationDefaultSetter.class);

    public void addDefaults(ConfigurationData configurationData) {
        if (configurationData.idpConfigurations != null) {
            for (IdpConfiguration idpConfig : configurationData.idpConfigurations) {
                this.addDefaults(idpConfig);
            }
        }
        if (configurationData.defaultRedirectUrl == null || configurationData.defaultRedirectUrl.trim().isEmpty()) {
            configurationData.defaultRedirectUrl = "/";
        }
        if (configurationData.loggedOutPageTemplate == null || configurationData.loggedOutPageTemplate.trim().isEmpty()) {
            logger.info("Setting loggedOutPageTempate to default");
            configurationData.loggedOutPageTemplate = "<html>\n <head>\n  <title>You are logged out now</title>\n  $webResourceManager.requireResource(\"$pluginproperties.pluginkey:resources\")\n  <meta name=\"decorator\" content=\"atl.general\">\n </head>\n <body class=\"aui-layout aui-theme-default page-type-message\" >\n  <section id=\"content\" role=\"main\">\n   <div class=\"aui-page-panel\"><div class=\"aui-page-panel-inner\">\n    <section class=\"aui-page-panel-content\">\n     <div class=\"form-body\">\n     <div class=\"aui-message info\"><span class=\"aui-icon icon-info\"></span><p class=\"title\">\n      <strong>You are logged out now</strong></p>\n      <p>\n       <a href=\"$loginurl\">Login again with username and password</a>\n      </p>\n      <p>\n       <a href=\"$ssourl\">Login again with Single Sign On</a>  \n      </p>\n     </div>\n    </div>\n   </section>\n  </div>\n </div>\n</section>\n</body>\n</html>";
        }
        if (configurationData.errorPageTemplate == null || configurationData.errorPageTemplate.trim().isEmpty()) {
            logger.info("Setting errorPageTempate to default");
            configurationData.errorPageTemplate = "<html>\n <head>\n  <title>SAML Single Sign On failed</title>\n  $webResourceManager.requireResource(\"$pluginproperties.pluginkey:resources\")\n  <meta name=\"decorator\" content=\"atl.general\">\n </head>\n  <body class=\"aui-page-focused aui-page-medium\" >\n   <div class=\"aui-page-panel\">\n    <div class=\"aui-page-panel-inner\">\n     <section class=\"aui-page-panel-content\">\n      <h1>SAML Single Sign On failed</h1>\n      <div>Please contact your administrator or log in at the <a href=\"$loginurl\">login page</a>.</div>\n      #if($userid)\n       <div class=\"aui-message error\">$userid could not be authorized. This userid is unknown or the user does not have sufficient permissions.</div>\n      #end\n      #if($message)\n       <div class=\"aui-message error\">$message</div>\n      #end\n      #if($stacktrace)\n      <a id=\"show-stacktrace-trigger\" data-replace-text=\"Hide Stack Trace\" class=\"aui-expander-trigger button\" aria-controls=\"stacktrace\">Show Stack Trace</a>\n      <div class=\"aui-expander-content\" id=\"stacktrace\">$stacktrace</div>\n      #end\n     </section>\n    </div>\n   </div>\n </body>\n</html>";
        }
        if (configurationData.idpSelectionPageTemplate == null || configurationData.idpSelectionPageTemplate.trim().isEmpty()) {
            logger.info("Setting idpSelectionPageTemplate to default");
            configurationData.idpSelectionPageTemplate = "<html>\n <head>\n  <title>Select Identity Provider</title>\n  $webResourceManager.requireResource(\"$pluginproperties.pluginkey:resources\")\n  <meta name=\"decorator\" content=\"atl.general\">\n </head>\n <body class=\"aui-layout aui-theme-default page-type-message\" >\n  <section id=\"content\" role=\"main\">\n   <div class=\"aui-page-panel\"><div class=\"aui-page-panel-inner\">\n    <section class=\"aui-page-panel-content\">\n     <div class=\"form-body\">\n     <h1>What kind of user are you?</h1>\n     #if($idpSelected)\n      <p>Select or wait 3 seconds to use $selectedName <span class=\"aui-icon aui-icon-wait\"></span></p>\n        <script>\n          var timeout = setTimeout(\"location.href = '$selectedUrl';\", 3000);\n          window.onclick= function () { clearTimeout(timeout); } \n        </script>\n      #end\n      #foreach($idp in $idps)\n      <p>\n        <a href=\"$idp.ssoUrl\">$idp.name</a> $idp.description\n      </p>\n      #end\n      <p>\n       <a href=\"$loginurl\">Login with username and password</a>\n      </p>\n     </div>\n   </section>\n  </div>\n </div>\n</section>\n</body>\n</html>";
        }
        if (configurationData.serviceDeskErrorPageTemplate == null || configurationData.serviceDeskErrorPageTemplate.trim().isEmpty()) {
            logger.info("Setting serviceDeskErrorPageTemplate to default");
            configurationData.serviceDeskErrorPageTemplate = "<html>\n <head>\n  <title>SAML Single Sign On failed</title>\n  $webResourceManager.requireResource(\"$pluginproperties.pluginkey:resources\")\n  <meta name=\"decorator\" content=\"atl.general\">\n </head>\n  <body class=\"aui-page-focused aui-page-medium\" >\n   <div class=\"aui-page-panel\">\n    <div class=\"aui-page-panel-inner\">\n     <section class=\"aui-page-panel-content\">\n      <h1>SAML Single Sign On failed</h1>\n      <div>Please contact your administrator or log in at the <a href=\"$loginurl\">login page</a>.</div>\n      #if($message)\n       <div class=\"aui-message error\">$message</div>\n      #end\n     </section>\n    </div>\n   </div>\n </body>\n</html>";
        }
        if (configurationData.idpByEmailPageTemplate == null || configurationData.idpByEmailPageTemplate.trim().isEmpty()) {
            logger.info("Setting idpByEmailPageTemplate to default");
            configurationData.idpByEmailPageTemplate = "#disable_html_escaping()\n<html>\n  <head>\n  <title>Enter your Email Address</title> \n  $webResourceManager.requireResource(\"$pluginproperties.pluginkey:idpByEmailResources\")\n  <meta name=\"decorator\" content=\"atl.general\">\n\t<script type=\"text/javascript\">\n\t  var emailDomains = $emailDomainMap;\n\t  var ssoURL = \"$ssourl\";\n\t</script>\n\t</head>\n\t<body class=\"aui-layout aui-theme-default page-type-message\">\n\t  <section id=\"content\" role=\"main\"> \n\t    <div class=\"aui-page-panel\">\n         <div class=\"aui-page-panel-inner\">\n           <section class=\"aui-page-panel-content\">\n             <h1>Single Sign On</h1>\n             <form class=\"aui top-label\" id=\"emailAddressForm\" >\n               <div class=\"field-group\">\n                 <label for=\"emailAddressField\">Enter your email address</label>\n                 <input type=\"text\" class=\"text\" id=\"emailAddressField\" name=\"emailAddressField\">\n                 <div class=\"description\">\n                   <div id=\"notFound\"   >No SSO destination found for this address</div>\n                   <div id=\"redirecting\"><span class=\"aui-icon aui-icon-wait\"></span>Redirecting...</div>\n                 </div>\n               </div>\n               <p><a href=\"$loginurl\">Login with username and password</a></p>\n             </form>\n           </section> \n         </div>\n       </div>\n     </section>\n\t</body>\n</html>";
        }
    }

    public ConfigurationData clearDefaults(ConfigurationData configurationDataToClear) {
        ConfigurationData configurationData = configurationDataToClear.clone();
        if (configurationData.idpConfigurations != null) {
            for (IdpConfiguration idpConfig : configurationData.idpConfigurations) {
                this.clearDefaults(idpConfig);
            }
        }
        if (configurationData.defaultRedirectUrl != null && configurationData.defaultRedirectUrl.equals("/")) {
            logger.debug("defaultRedirectUrl is default, clearing");
            configurationData.defaultRedirectUrl = null;
        }
        if (configurationData.loggedOutPageTemplate != null && configurationData.loggedOutPageTemplate.equals("<html>\n <head>\n  <title>You are logged out now</title>\n  $webResourceManager.requireResource(\"$pluginproperties.pluginkey:resources\")\n  <meta name=\"decorator\" content=\"atl.general\">\n </head>\n <body class=\"aui-layout aui-theme-default page-type-message\" >\n  <section id=\"content\" role=\"main\">\n   <div class=\"aui-page-panel\"><div class=\"aui-page-panel-inner\">\n    <section class=\"aui-page-panel-content\">\n     <div class=\"form-body\">\n     <div class=\"aui-message info\"><span class=\"aui-icon icon-info\"></span><p class=\"title\">\n      <strong>You are logged out now</strong></p>\n      <p>\n       <a href=\"$loginurl\">Login again with username and password</a>\n      </p>\n      <p>\n       <a href=\"$ssourl\">Login again with Single Sign On</a>  \n      </p>\n     </div>\n    </div>\n   </section>\n  </div>\n </div>\n</section>\n</body>\n</html>")) {
            logger.debug("loggedOutPageTemplate is default, clearing");
            configurationData.loggedOutPageTemplate = null;
        }
        if (configurationData.errorPageTemplate != null && configurationData.errorPageTemplate.equals("<html>\n <head>\n  <title>SAML Single Sign On failed</title>\n  $webResourceManager.requireResource(\"$pluginproperties.pluginkey:resources\")\n  <meta name=\"decorator\" content=\"atl.general\">\n </head>\n  <body class=\"aui-page-focused aui-page-medium\" >\n   <div class=\"aui-page-panel\">\n    <div class=\"aui-page-panel-inner\">\n     <section class=\"aui-page-panel-content\">\n      <h1>SAML Single Sign On failed</h1>\n      <div>Please contact your administrator or log in at the <a href=\"$loginurl\">login page</a>.</div>\n      #if($userid)\n       <div class=\"aui-message error\">$userid could not be authorized. This userid is unknown or the user does not have sufficient permissions.</div>\n      #end\n      #if($message)\n       <div class=\"aui-message error\">$message</div>\n      #end\n      #if($stacktrace)\n      <a id=\"show-stacktrace-trigger\" data-replace-text=\"Hide Stack Trace\" class=\"aui-expander-trigger button\" aria-controls=\"stacktrace\">Show Stack Trace</a>\n      <div class=\"aui-expander-content\" id=\"stacktrace\">$stacktrace</div>\n      #end\n     </section>\n    </div>\n   </div>\n </body>\n</html>")) {
            logger.debug("errorPageTemplate is default, clearing");
            configurationData.errorPageTemplate = null;
        }
        if (configurationData.idpSelectionPageTemplate != null && configurationData.idpSelectionPageTemplate.equals("<html>\n <head>\n  <title>Select Identity Provider</title>\n  $webResourceManager.requireResource(\"$pluginproperties.pluginkey:resources\")\n  <meta name=\"decorator\" content=\"atl.general\">\n </head>\n <body class=\"aui-layout aui-theme-default page-type-message\" >\n  <section id=\"content\" role=\"main\">\n   <div class=\"aui-page-panel\"><div class=\"aui-page-panel-inner\">\n    <section class=\"aui-page-panel-content\">\n     <div class=\"form-body\">\n     <h1>What kind of user are you?</h1>\n     #if($idpSelected)\n      <p>Select or wait 3 seconds to use $selectedName <span class=\"aui-icon aui-icon-wait\"></span></p>\n        <script>\n          var timeout = setTimeout(\"location.href = '$selectedUrl';\", 3000);\n          window.onclick= function () { clearTimeout(timeout); } \n        </script>\n      #end\n      #foreach($idp in $idps)\n      <p>\n        <a href=\"$idp.ssoUrl\">$idp.name</a> $idp.description\n      </p>\n      #end\n      <p>\n       <a href=\"$loginurl\">Login with username and password</a>\n      </p>\n     </div>\n   </section>\n  </div>\n </div>\n</section>\n</body>\n</html>")) {
            logger.debug("idpSelectionPageTemplate is default, clearing");
            configurationData.idpSelectionPageTemplate = null;
        }
        if (configurationData.serviceDeskErrorPageTemplate != null && configurationData.serviceDeskErrorPageTemplate.equals("<html>\n <head>\n  <title>SAML Single Sign On failed</title>\n  $webResourceManager.requireResource(\"$pluginproperties.pluginkey:resources\")\n  <meta name=\"decorator\" content=\"atl.general\">\n </head>\n  <body class=\"aui-page-focused aui-page-medium\" >\n   <div class=\"aui-page-panel\">\n    <div class=\"aui-page-panel-inner\">\n     <section class=\"aui-page-panel-content\">\n      <h1>SAML Single Sign On failed</h1>\n      <div>Please contact your administrator or log in at the <a href=\"$loginurl\">login page</a>.</div>\n      #if($message)\n       <div class=\"aui-message error\">$message</div>\n      #end\n     </section>\n    </div>\n   </div>\n </body>\n</html>")) {
            logger.debug("serviceDeskErrorPageTemplate is default, clearing");
            configurationData.serviceDeskErrorPageTemplate = null;
        }
        if (configurationData.idpByEmailPageTemplate != null && configurationData.idpByEmailPageTemplate.equals("#disable_html_escaping()\n<html>\n  <head>\n  <title>Enter your Email Address</title> \n  $webResourceManager.requireResource(\"$pluginproperties.pluginkey:idpByEmailResources\")\n  <meta name=\"decorator\" content=\"atl.general\">\n\t<script type=\"text/javascript\">\n\t  var emailDomains = $emailDomainMap;\n\t  var ssoURL = \"$ssourl\";\n\t</script>\n\t</head>\n\t<body class=\"aui-layout aui-theme-default page-type-message\">\n\t  <section id=\"content\" role=\"main\"> \n\t    <div class=\"aui-page-panel\">\n         <div class=\"aui-page-panel-inner\">\n           <section class=\"aui-page-panel-content\">\n             <h1>Single Sign On</h1>\n             <form class=\"aui top-label\" id=\"emailAddressForm\" >\n               <div class=\"field-group\">\n                 <label for=\"emailAddressField\">Enter your email address</label>\n                 <input type=\"text\" class=\"text\" id=\"emailAddressField\" name=\"emailAddressField\">\n                 <div class=\"description\">\n                   <div id=\"notFound\"   >No SSO destination found for this address</div>\n                   <div id=\"redirecting\"><span class=\"aui-icon aui-icon-wait\"></span>Redirecting...</div>\n                 </div>\n               </div>\n               <p><a href=\"$loginurl\">Login with username and password</a></p>\n             </form>\n           </section> \n         </div>\n       </div>\n     </section>\n\t</body>\n</html>")) {
            logger.debug("idpByEmailPageTemplate is default, clearing");
            configurationData.idpByEmailPageTemplate = null;
        }
        return configurationData;
    }

    public void addDefaults(IdpConfiguration idpConfig) {
        if (idpConfig.getRelayStateParameterName() == null || idpConfig.getRelayStateParameterName().trim().isEmpty()) {
            logger.debug("Setting RelayState parameter name to default {}", (Object)"RelayState");
            idpConfig.setRelayStateParameterName("RelayState");
        }
    }

    private void clearDefaults(IdpConfiguration idpConfig) {
        if (idpConfig.getRelayStateParameterName() != null && idpConfig.getRelayStateParameterName().equals("RelayState")) {
            logger.debug("relayStateParameterName is default, clearing it");
            idpConfig.setRelayStateParameterName(null);
        }
    }
}

