/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import java.security.cert.X509Certificate;
import java.util.Collection;
import org.opensaml.xml.security.x509.X509Util;

public class CertificateCheck {
    private String base64encocedCertificate;
    private boolean valid = false;
    private boolean certSet = false;
    private String readable = "not checked";

    public CertificateCheck(String base64encocedCertificate) {
        this.base64encocedCertificate = base64encocedCertificate;
        if (base64encocedCertificate == null || base64encocedCertificate.trim().isEmpty()) {
            this.readable = "no certificate";
            this.certSet = false;
        } else {
            this.certSet = true;
            try {
                Collection<X509Certificate> certs = X509Util.decodeCertificate(base64encocedCertificate.getBytes());
                this.readable = certs.iterator().next().toString();
                this.valid = true;
            }
            catch (Exception e) {
                this.readable = "Decoding certificate failed: " + e.getMessage();
                this.valid = false;
            }
        }
    }

    public String getBase64encocedCertificate() {
        return this.base64encocedCertificate;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getReadable() {
        return this.readable;
    }

    public boolean isCertSet() {
        return this.certSet;
    }
}

