/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.resolution.atlasplugins.samlsso.AuthenticatorHook;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.UserPreparationException;
import com.resolution.atlasplugins.samlsso.cluster.ClusterNotificationListener;
import com.resolution.atlasplugins.samlsso.cluster.ClusterNotificator;
import com.resolution.atlasplugins.samlsso.configuration.PluginConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.PluginConfigurationListener;
import com.resolution.samlprocessor.SAMLProcessor;
import com.resolution.samlprocessor.SAMLProcessorException;
import com.resolution.samlprocessor.SAMLResponseContent;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSamlSsoService
implements PluginConfigurationListener,
ClusterNotificationListener,
SamlSsoService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSamlSsoService.class);
    private static final String CONFIG_UPDATED_MESSAGE = "configUpdated";
    protected boolean initialized = false;
    protected final PluginConfiguration pluginConfiguration;
    protected final ApplicationProperties applicationProperties;
    protected final AuthenticatorHook authenticatorHook;
    protected final ClusterNotificator clusterNotificator;
    protected final CrowdDirectoryService crowdDirectoryService;
    protected SAMLProcessor samlProcessor;

    public AbstractSamlSsoService(PluginConfiguration pluginConfiguration, ApplicationProperties applicationProperties, EventPublisher eventPublisher, CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, AuthenticatorHook authenticatorHook, ClusterNotificator clusterNotificator) {
        this.pluginConfiguration = pluginConfiguration;
        this.pluginConfiguration.addListener(this);
        this.applicationProperties = applicationProperties;
        this.crowdDirectoryService = crowdDirectoryService;
        this.authenticatorHook = authenticatorHook;
        this.clusterNotificator = clusterNotificator;
        if (this.clusterNotificator != null) {
            this.clusterNotificator.register(this);
        }
        this.applyConfiguration();
        logger.debug("Finished constructing SamlSsoService");
    }

    @Override
    public abstract String getLoginPageUrl();

    @Override
    public abstract String getRedirectUrlForLogin(HttpServletRequest var1);

    protected String getRedirectUrlForLogin(HttpServletRequest request, String loginPageName) {
        String contextPath;
        String requestURI = request.getRequestURI();
        String path = requestURI.substring((contextPath = request.getContextPath()).length());
        if (path.contains(loginPageName)) {
            String referer = request.getHeader("referer");
            logger.debug("REFERER   === {}", (Object)referer);
            if (referer != null && referer.contains(loginPageName)) {
                logger.debug("Referer {} contains {}, not redirecting", (Object)referer, (Object)loginPageName);
                return null;
            }
            String os_destination = request.getParameter("os_destination");
            if (os_destination == null) {
                return this.getSSOUrl();
            }
            try {
                os_destination = URLEncoder.encode(os_destination, "UTF-8");
                logger.debug("Re-encoded destination is {}", (Object)os_destination);
            }
            catch (UnsupportedEncodingException e) {
                logger.error("URLencoding failed, THIS SHOULD NEVER HAPPEN!", (Throwable)e);
            }
            for (String nonSsoDestination : this.pluginConfiguration.getNonSsoDestinationsList()) {
                if (!os_destination.contains(nonSsoDestination)) continue;
                logger.debug("Not redirecting, this is a non-sso link url: {}", (Object)os_destination);
                return null;
            }
            return this.getSSOUrl() + "?redirectTo=" + os_destination;
        }
        for (String enforcedSsoDestination : this.pluginConfiguration.getEnforceSsoDestinationsList()) {
            if (!Pattern.matches(enforcedSsoDestination, path)) continue;
            String queryString = request.getQueryString();
            String pathWithQueryString = path;
            if (queryString != null) {
                pathWithQueryString = pathWithQueryString + "?" + queryString;
            }
            String encodedPathWithQueryString = null;
            try {
                encodedPathWithQueryString = URLEncoder.encode(pathWithQueryString, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Encoding " + queryString + " failed, THIS SHOULD NEVER HAPPEN", (Throwable)e);
            }
            logger.debug("QUERYSTRING === {}", (Object)queryString);
            logger.debug("PATHWQSTR   === {}", (Object)pathWithQueryString);
            logger.debug("EPATHWQSTR  === {}", (Object)encodedPathWithQueryString);
            String redirectURL = this.getSSOUrl() + "?redirectTo=" + encodedPathWithQueryString;
            logger.debug("URL matched erforced SSO Regex {}, redirecting to {}", (Object)path, (Object)redirectURL);
            return redirectURL;
        }
        return null;
    }

    @Override
    public abstract String getRedirectUrlForLogout(HttpServletRequest var1);

    @Override
    public abstract boolean prepareUser(SAMLResponseContent var1, boolean var2, boolean var3) throws UserPreparationException;

    @Override
    public boolean isLoggedInUser() {
        return this.authenticatorHook.isLoggedInUser();
    }

    @Override
    public SAMLProcessor getSamlProcessor() {
        return this.samlProcessor;
    }

    @Override
    public String generateSamlMetadata() throws SAMLProcessorException {
        if (!this.initialized) {
            logger.warn("Not initialized, returning null as metadata!");
            return null;
        }
        return this.samlProcessor.generateMetadata(this.getConsumerUrl());
    }

    @Override
    public String getConsumerUrl() {
        return this.getAbsoluteBaseUrl() + "/plugins/servlet/samlsso";
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public String getAbsoluteBaseUrl() {
        String url = this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        logger.trace("returning absolute base URL {}", (Object)url);
        return url;
    }

    @Override
    public String getRelativeBaseUrl() {
        String url = this.applicationProperties.getBaseUrl(UrlMode.RELATIVE_CANONICAL);
        return url;
    }

    @Override
    public String getSSOUrl() {
        return this.getAbsoluteBaseUrl() + "/plugins/servlet/samlsso";
    }

    @Override
    public String getRedirectURLForRequest(HttpServletRequest request) {
        if (logger.isTraceEnabled()) {
            logger.trace("Request is for {} | {}", (Object)request.getRequestURL().toString(), (Object)request.getQueryString());
            String servletPath = request.getServletPath();
            logger.trace("Servlet path is {}", (Object)servletPath);
        }
        boolean overrideLogOutURL = this.pluginConfiguration.isOverrideLogoutUrl();
        boolean redirectLogin = this.pluginConfiguration.isOverrideLoginUrl();
        if (!overrideLogOutURL && !redirectLogin) {
            return null;
        }
        if (request.getParameter("nosso") != null) {
            logger.trace("nosso parameter is present, not redirecting");
            return null;
        }
        String userAgentHeader = request.getHeader("user-agent");
        for (String nonSsoUserAgent : this.pluginConfiguration.getNonSsoUserAgentsList()) {
            if (userAgentHeader == null || !userAgentHeader.contains(nonSsoUserAgent)) continue;
            logger.trace("Not redirecting, this is a non-sso user agent: {}", (Object)userAgentHeader);
            return null;
        }
        if (this.authenticatorHook.isLoggedInUser()) {
            if (overrideLogOutURL) {
                return this.getRedirectUrlForLogout(request);
            }
            return null;
        }
        if (redirectLogin) {
            return this.getRedirectUrlForLogin(request);
        }
        logger.trace("Login redirection is disabled, returning null");
        return null;
    }

    @Override
    public AuthenticatorHook getAuthenticatorHook() {
        return this.authenticatorHook;
    }

    @Override
    public void configurationUpdated() {
        this.pluginConfiguration.load();
        this.applyConfiguration();
        if (this.clusterNotificator != null) {
            logger.debug("Sending configuration updated message to the cluster");
            this.clusterNotificator.send(CONFIG_UPDATED_MESSAGE);
        }
    }

    @Override
    public void receiveClusterNotification(String message) {
        if (message.equals(CONFIG_UPDATED_MESSAGE)) {
            logger.info("Configuration was updated on other cluster node. Reloading configuration.");
            this.pluginConfiguration.load();
            this.applyConfiguration();
        } else {
            logger.debug("Received message {} from cluster. Ignoring it.", (Object)message);
        }
    }

    protected void applyConfiguration() {
        logger.debug("Reading writable directories");
        try {
            this.samlProcessor = new SAMLProcessor(this.getConsumerUrl(), this.pluginConfiguration.getIdpConfigurations(), this.pluginConfiguration.isEnforceResponseValidityDates(), this.pluginConfiguration.isEnforceResponseIDUniqueness(), this.pluginConfiguration.getClockSkew());
            this.initialized = true;
        }
        catch (SAMLProcessorException e) {
            logger.error("Creating SAMLProcessor failed", (Throwable)e);
            this.initialized = false;
        }
    }

    @Override
    public final boolean checkForSamlSsoAuthenticator() {
        Authenticator authenticator = SecurityConfigFactory.getInstance().getAuthenticator();
        Class<?>[] authenticatorInterfaces = authenticator.getClass().getInterfaces();
        for (int i = 0; i < authenticatorInterfaces.length; ++i) {
            if (!authenticatorInterfaces[i].getName().equals("com.resolution.samlsso.authenticator.SamlSsoAuthenticator")) continue;
            logger.debug("Authenticator {} implements SamlSsoAuthenticator", (Object)authenticator.getClass().getName());
            return true;
        }
        logger.debug("Authenticator {} does not implement SamlSsoAuthenticator", (Object)authenticator.getClass().getName());
        return false;
    }

    @Override
    public boolean isJira7() {
        return false;
    }

    @Override
    public boolean isJira6() {
        return false;
    }

    @Override
    public boolean isJiraServiceDesk() {
        return false;
    }

    @Override
    public boolean isConfluence() {
        return false;
    }
}

