/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.soap.client.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.opensaml.ws.security.SecurityPolicy;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.ws.soap.client.SOAPClient;
import org.opensaml.ws.soap.client.SOAPClientException;
import org.opensaml.ws.soap.client.SOAPFaultException;
import org.opensaml.ws.soap.client.SOAPMessageContext;
import org.opensaml.ws.soap.client.http.HttpSOAPRequestParameters;
import org.opensaml.ws.soap.common.SOAPException;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.ws.soap.soap11.Fault;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class HttpSOAPClient
implements SOAPClient {
    private final Logger log = LoggerFactory.getLogger(HttpSOAPClient.class);
    private HttpClient httpClient;
    private ParserPool parserPool;

    public HttpSOAPClient(HttpClient client, ParserPool parser) {
        if (client == null) {
            throw new IllegalArgumentException("HtppClient may not be null");
        }
        this.httpClient = client;
        if (parser == null) {
            throw new IllegalArgumentException("ParserPool may not be null");
        }
        this.parserPool = parser;
    }

    @Override
    public void send(String endpoint, SOAPMessageContext messageContext) throws SOAPException, SecurityException {
        block8: {
            HttpMethodBase post = null;
            try {
                post = this.createPostMethod(endpoint, (HttpSOAPRequestParameters)messageContext.getSOAPRequestParameters(), (Envelope)messageContext.getOutboundMessage());
                int result = this.httpClient.executeMethod(post);
                this.log.debug("Received HTTP status code of {} when POSTing SOAP message to {}", (Object)result, (Object)endpoint);
                if (result == 200) {
                    this.processSuccessfulResponse((PostMethod)post, messageContext);
                    break block8;
                }
                if (result == 500) {
                    this.processFaultResponse((PostMethod)post, messageContext);
                    break block8;
                }
                throw new SOAPClientException("Received " + result + " HTTP response status code from HTTP request to " + endpoint);
            }
            catch (IOException e) {
                throw new SOAPClientException("Unable to send request to " + endpoint, e);
            }
            finally {
                if (post != null) {
                    post.releaseConnection();
                }
            }
        }
    }

    protected PostMethod createPostMethod(String endpoint, HttpSOAPRequestParameters requestParams, Envelope message) throws SOAPClientException {
        this.log.debug("POSTing SOAP message to {}", (Object)endpoint);
        PostMethod post = new PostMethod(endpoint);
        post.setRequestEntity(this.createRequestEntity(message, Charset.forName("UTF-8")));
        if (requestParams != null && requestParams.getSoapAction() != null) {
            post.setRequestHeader("SOAPAction", requestParams.getSoapAction());
        }
        return post;
    }

    protected RequestEntity createRequestEntity(Envelope message, Charset charset) throws SOAPClientException {
        try {
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(message);
            ByteArrayOutputStream arrayOut = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)arrayOut, charset);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Outbound SOAP message is:\n" + XMLHelper.prettyPrintXML(marshaller.marshall(message)));
            }
            XMLHelper.writeNode((Node)marshaller.marshall(message), writer);
            return new ByteArrayRequestEntity(arrayOut.toByteArray(), "text/xml");
        }
        catch (MarshallingException e) {
            throw new SOAPClientException("Unable to marshall SOAP envelope", e);
        }
    }

    protected void processSuccessfulResponse(PostMethod httpMethod, SOAPMessageContext messageContext) throws SOAPClientException {
        try {
            Envelope response = this.unmarshallResponse(httpMethod.getResponseBodyAsStream());
            messageContext.setInboundMessage(response);
            this.evaluateSecurityPolicy(messageContext);
        }
        catch (IOException e) {
            throw new SOAPClientException("Unable to read response", e);
        }
    }

    protected void processFaultResponse(PostMethod httpMethod, SOAPMessageContext messageContext) throws SOAPClientException, SOAPFaultException {
        try {
            Envelope response = this.unmarshallResponse(httpMethod.getResponseBodyAsStream());
            messageContext.setInboundMessage(response);
            List<XMLObject> faults = response.getBody().getUnknownXMLObjects(Fault.DEFAULT_ELEMENT_NAME);
            if (faults.size() < 1) {
                throw new SOAPClientException("HTTP status code was 500 but SOAP response did not contain a Fault");
            }
            Fault fault = (Fault)faults.get(0);
            this.log.debug("SOAP fault code {} with message {}", (Object)fault.getCode().getValue(), (Object)fault.getMessage().getValue());
            SOAPFaultException faultException = new SOAPFaultException("SOAP Fault: " + fault.getCode().getValue() + " Fault Message: " + fault.getMessage().getValue());
            faultException.setFault(fault);
            throw faultException;
        }
        catch (IOException e) {
            throw new SOAPClientException("Unable to read response", e);
        }
    }

    protected Envelope unmarshallResponse(InputStream responseStream) throws SOAPClientException {
        try {
            Element responseElem = this.parserPool.parse(responseStream).getDocumentElement();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Inbound SOAP message was:\n" + XMLHelper.prettyPrintXML(responseElem));
            }
            Unmarshaller unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(responseElem);
            return (Envelope)unmarshaller.unmarshall(responseElem);
        }
        catch (XMLParserException e) {
            throw new SOAPClientException("Unable to parse the XML within the response", e);
        }
        catch (UnmarshallingException e) {
            throw new SOAPClientException("unable to unmarshall the response DOM", e);
        }
    }

    protected void evaluateSecurityPolicy(SOAPMessageContext messageContext) throws SOAPClientException {
        SecurityPolicyResolver policyResolver = messageContext.getSecurityPolicyResolver();
        if (policyResolver == null) {
            return;
        }
        SecurityPolicy policy = null;
        try {
            policy = (SecurityPolicy)policyResolver.resolveSingle(messageContext);
            if (policy == null) {
                return;
            }
        }
        catch (SecurityException e) {
            throw new SOAPClientException("Unable to resolve security policy for inbound SOAP response", e);
        }
        try {
            this.log.debug("Evaluating security policy for inbound SOAP response");
            policy.evaluate(messageContext);
        }
        catch (SecurityException e) {
            throw new SOAPClientException("Inbound SOAP response does not meet security policy", e);
        }
    }
}

