/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.confluence.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.security.password.Credential;
import com.miniorange.sso.saml.SAMLException;
import com.miniorange.sso.saml.SAMLManager;
import com.miniorange.sso.saml.SAMLResponse;
import com.miniorange.sso.saml.confluence.SAMLSettings;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.xml.util.Base64;
import org.springframework.web.util.HtmlUtils;

public class SAMLLoginServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(SAMLLoginServlet.class);
    private SAMLSettings settings;
    private SAMLManager samlManager;
    private UserManager userManager;

    public SAMLLoginServlet(SAMLSettings settings, UserManager userManager, SAMLManager samlManager) {
        this.settings = settings;
        this.userManager = userManager;
        this.samlManager = samlManager;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String returnTo = request.getParameter("return_to");
        String title = request.getParameter("title");
        if (StringUtils.isBlank((CharSequence)returnTo)) {
            returnTo = this.settings.getDashboardUrl();
        } else {
            if (StringUtils.containsIgnoreCase((CharSequence)returnTo, (CharSequence)"displaysamlrequest")) {
                StringBuilder output = new StringBuilder("<div style='display:none'>");
                String message = this.samlManager.getTestAuthnRequest();
                message = HtmlUtils.htmlEscape((String)message);
                output.append(message);
                output.append("</div>");
                output.append("<div style='color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;'>Authentication(SAML) Request</div>");
                output.append("<textarea rows='6' cols='100' word-wrap='break-word;' style='width:778px; margin:0px; height:350px;' id ='reqmessage' readonly>" + message + "</textarea> ");
                output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input style=\"padding:1%;width:100px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Done\" onClick=\"self.close();\"></div>");
                output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input id =\"copy-button\" style=\"padding:1%;width:150px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Copy to Clipboard\"></div>");
                output.append("<script>document.querySelector(\"#copy-button\").onclick = function() {document.querySelector(\"#reqmessage\").select();document.execCommand('copy');};</script>");
                response.setContentType("text/html");
                response.getOutputStream().write(output.toString().getBytes());
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)title)) {
                StringBuilder returnToUrl = new StringBuilder();
                returnToUrl.append(returnTo).append("&").append("title").append("=");
                returnToUrl.append(title);
                returnTo = returnToUrl.toString();
            }
        }
        this.samlManager.createAuthnRequestAndRedirect(request, response, returnTo);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            Authenticator authenticator;
            LOGGER.debug("SAML Authentication Servlet doPost() called...");
            SAMLResponse samlResponse = null;
            String relayState = request.getParameter("RelayState");
            if (StringUtils.contains((CharSequence)relayState, (CharSequence)"displaysamlresponse")) {
                StringBuilder output = new StringBuilder("<div style='display:none'>");
                String encodedSAMLResponse = request.getParameter("SAMLResponse");
                String xml = new String(Base64.decode(encodedSAMLResponse), "UTF-8");
                xml = HtmlUtils.htmlEscape((String)xml);
                output.append(xml);
                output.append("</div>");
                output.append("<div style='color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;'>SAML Response</div>");
                output.append("<textarea rows='6' cols='100' word-wrap='break-word;' style='width:778px; margin:0px; height:350px;' id ='resmessage' readonly>" + xml + "</textarea> ");
                output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input style=\"padding:1%;width:100px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Done\" onClick=\"self.close();\"></div>");
                output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input id =\"copy-button\" style=\"padding:1%;width:150px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Copy to Clipboard\"></div>");
                output.append("<script>document.querySelector(\"#copy-button\").onclick = function() {document.querySelector(\"#resmessage\").select();document.execCommand('copy');};</script>");
                response.setContentType("text/html");
                response.getOutputStream().write(output.toString().getBytes());
                return;
            }
            try {
                samlResponse = this.samlManager.readSAMLResponse(request, response);
            }
            catch (SAMLException e) {
                if (StringUtils.contains((CharSequence)relayState, (CharSequence)"testidpconfiguration")) {
                    this.showTestConfigurationResult(null, response, e);
                    return;
                }
                this.redirectToLoginWithSAMLError(response, null, "cant_signin_check_configuration");
                return;
            }
            if (StringUtils.contains((CharSequence)samlResponse.getRelayStateURL(), (CharSequence)"testidpconfiguration")) {
                this.showTestConfigurationResult(samlResponse, response, null);
                return;
            }
            String username = "";
            String email = "";
            if (samlResponse.getAttributes().get(this.settings.getUsernameAttribute()) != null && samlResponse.getAttributes().get(this.settings.getUsernameAttribute()).length == 1) {
                username = samlResponse.getAttributes().get(this.settings.getUsernameAttribute())[0];
            }
            if (samlResponse.getAttributes().get(this.settings.getEmailAttribute()) != null && samlResponse.getAttributes().get(this.settings.getEmailAttribute()).length == 1) {
                email = samlResponse.getAttributes().get(this.settings.getEmailAttribute())[0];
            }
            LOGGER.debug("Username received: " + username + ", Email received: " + email);
            if (StringUtils.isNotBlank((CharSequence)username) && (authenticator = SecurityConfigFactory.getInstance().getAuthenticator()) instanceof DefaultAuthenticator) {
                Method getUserMethod = DefaultAuthenticator.class.getDeclaredMethod("getUser", String.class);
                getUserMethod.setAccessible(true);
                Object userObject = getUserMethod.invoke((Object)authenticator, username);
                if (userObject == null) {
                    LOGGER.debug("User doesn't exist. Creating New User.");
                    userObject = this.tryCreateOrUpdateUser(username, email);
                }
                LOGGER.debug("Establishing session for: " + userObject);
                Boolean result = this.authoriseUserAndEstablishSession((DefaultAuthenticator)authenticator, userObject, request, response);
                if (result.booleanValue()) {
                    LOGGER.debug("Session created. Redirecting user to " + samlResponse.getRelayStateURL());
                    this.redirectToSuccessfulAuthLandingPage(request, response, samlResponse.getRelayStateURL());
                    return;
                }
                LOGGER.debug("Session could NOT be created. Redirecting user to login page.");
            }
            LOGGER.error("Username not received in the SAML Response. Please check your configuration.");
        }
        catch (Exception e) {
            LOGGER.error("An error occured while verifying the SAML Response.", e);
        }
        this.redirectToLoginWithSAMLError(response, null, "cant_signin_check_configuration");
    }

    protected Boolean authoriseUserAndEstablishSession(DefaultAuthenticator authenticator, Object userObject, HttpServletRequest request, HttpServletResponse response) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Principal principal = (Principal)userObject;
        Method authUserMethod = DefaultAuthenticator.class.getDeclaredMethod("authoriseUserAndEstablishSession", HttpServletRequest.class, HttpServletResponse.class, Principal.class);
        authUserMethod.setAccessible(true);
        return (Boolean)authUserMethod.invoke((Object)authenticator, request, response, principal);
    }

    protected void redirectToSuccessfulAuthLandingPage(HttpServletRequest request, HttpServletResponse response, String relayState) throws IOException {
        String redirectUrl = this.settings.getDashboardUrl();
        if (StringUtils.isNotBlank((CharSequence)relayState)) {
            redirectUrl = StringUtils.contains((CharSequence)relayState, (CharSequence)"://") ? relayState : this.settings.getBaseUrl().concat(relayState);
        }
        LOGGER.debug("Redirecting user to " + redirectUrl);
        this.redirect(response, redirectUrl);
    }

    protected void redirectToLoginWithSAMLError(HttpServletResponse response, Exception exception, String string) throws ServletException {
        try {
            if (exception != null) {
                LOGGER.error("SAML Plugin error: " + exception.getMessage(), exception);
            }
            this.redirect(response, this.settings.getDashboardUrl() + "?samlerror=" + string);
        }
        catch (IOException ioException) {
            throw new ServletException();
        }
    }

    protected ConfluenceUser tryCreateOrUpdateUser(String username, String email) throws UserNotFoundException, OperationFailedException, GroupNotFoundException, OperationNotPermittedException, IllegalArgumentException, EntityException {
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        ConfluenceUser createdUser = userAccessor.createUser((User)new DefaultUser(username, username, email), Credential.NONE);
        ConfluenceUser administratorUser = this.getAdministratorUser();
        String defaultGroup = this.settings.getDefaultGroup();
        if (defaultGroup.isEmpty()) {
            defaultGroup = "confluence-users";
        }
        Group confluenceUsersGroup = userAccessor.getGroup(defaultGroup);
        if (administratorUser != null && confluenceUsersGroup != null) {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)administratorUser);
            userAccessor.addMembership(confluenceUsersGroup, (User)createdUser);
        }
        return createdUser;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setSettings(SAMLSettings settings) {
        this.settings = settings;
    }

    public void setSamlManager(SAMLManager samlManager) {
        this.samlManager = samlManager;
    }

    private ConfluenceUser getAdministratorUser() {
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getInstance().getContainerContext().getComponent((Object)"userAccessor");
        List administratorNames = userAccessor.getMemberNamesAsList(userAccessor.getGroup("confluence-administrators"));
        if (administratorNames != null && administratorNames.size() > 0) {
            return userAccessor.getUserByName((String)administratorNames.get(0));
        }
        return null;
    }

    private void redirect(HttpServletResponse response, String url) throws IOException {
        StringBuffer htmlStart = new StringBuffer("<html><head><script>window.onload = function() {window.location.href=\"" + url + "\"};</script></head><body>Please wait...</body></html>");
        response.getOutputStream().write(htmlStart.toString().getBytes());
    }

    private void showTestConfigurationResult(SAMLResponse samlResponse, HttpServletResponse response, SAMLException e) throws IOException {
        if (e == null) {
            String username = "";
            StringBuffer htmlStart = new StringBuffer("<div style=\"font-family:Calibri;padding:0 3%;\">");
            String[] usernameArray = samlResponse.getAttributes().get(this.settings.getUsernameAttribute());
            if (usernameArray != null && usernameArray.length == 1) {
                username = usernameArray[0];
            }
            htmlStart = StringUtils.isBlank((CharSequence)username) ? htmlStart.append("<div style=\"color: #a94442;background-color: #f2dede;padding: 15px;margin-bottom: 20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div><div style=\"color: #a94442;font-size:14pt; margin-bottom:20px;\">WARNING: Username attribute not found in the response. Users will not be able to login.</div>") : htmlStart.append("<div style=\"color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;\">TEST SUCCESSFUL</div>");
            htmlStart = htmlStart.append("<span style=\"font-size:14pt;\"><b>Hello</b>, " + username + "</span><br/><p style=\"font-weight:bold;font-size:14pt;margin-left:1%;\">ATTRIBUTES RECEIVED:</p><table style=\"border-collapse:collapse;border-spacing:0; display:table;width:100%; font-size:14pt;background-color:#EDEDED;\"><tr style=\"text-align:center;\"><td style=\"font-weight:bold;border:2px solid #949090;padding:2%;\">ATTRIBUTE NAME</td><td style=\"font-weight:bold;padding:2%;border:2px solid #949090; word-wrap:break-word;\">ATTRIBUTE VALUE</td></tr>");
            for (String key : samlResponse.getAttributes().keySet()) {
                htmlStart = htmlStart.append("<tr><td style=\"font-weight:bold;border:2px solid #949090;padding:2%;\">" + key + "</td><td style=\"padding:2%;border:2px solid #949090;word-wrap:break-word;\">");
                Object[] values = samlResponse.getAttributes().get(key);
                for (int i = 0; i < values.length; ++i) {
                    htmlStart = htmlStart.append(StringUtils.join((Object[])values, (String)"<hr/>"));
                }
                htmlStart = htmlStart.append("</td></tr>");
            }
            htmlStart = htmlStart.append("</table></div>");
            htmlStart = htmlStart.append("<div style=\"margin:3%;display:block;text-align:center;\"><input style=\"padding:1%;width:100px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Done\" onClick=\"self.close();\"></div>");
            response.getOutputStream().write(htmlStart.toString().getBytes());
        } else {
            StringBuffer htmlStart = new StringBuffer("<div style=\"font-family:Calibri;padding:0 3%;\">");
            htmlStart = htmlStart.append("<div style=\"color:#a94442;background-color:#f2dede;padding:15px;margin-bottom:20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div>");
            htmlStart = htmlStart.append("<table style=\"border-collapse:collapse;border-spacing:0; display:table;width:100%;font-size:14pt;\"><tr style=\"padding-top:10px;padding-bottom:10px;\"><td style=\"font-weight:bold;padding:10px 5px 10px 5px;\">Error Code</td><td style=\"word-wrap:break-word;\">" + (Object)((Object)e.getErrorCode()) + "</td></tr><tr><td style=\"font-weight:bold;padding:10px 5px 10px 5px;\">Error Message</td><td style=\"word-wrap:break-word;\">" + e.getMessage() + "</td></tr><tr><td style=\"font-weight:bold;padding:10px 5px 10px 5px;\">Resolution</td><td style=\"word-wrap:break-word;\">" + e.getResolution() + "</tr></table></div>");
            response.getOutputStream().write(htmlStart.toString().getBytes());
        }
    }
}

