/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.confluence;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.miniorange.sso.saml.Customer;
import com.miniorange.sso.saml.PluginHandler;
import com.miniorange.sso.saml.confluence.SAMLSettings;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidateOTPAndRegisterAction
extends ConfluenceActionSupport {
    private static Log LOGGER = LogFactory.getLog(ValidateOTPAndRegisterAction.class);
    private Boolean submitted;
    private Boolean backToRegister;
    private SAMLSettings settings;
    private String token;

    public void validate() {
        if (!BooleanUtils.toBoolean((Boolean)this.submitted)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.token)) {
            this.addActionError(this.getText("samlsso.error.validate.token.empty"));
        }
    }

    public String execute() throws Exception {
        if (BooleanUtils.toBoolean((Boolean)this.backToRegister)) {
            this.settings.removeCustomerAccount();
            return "error";
        }
        if (this.getCurrentSession().getAttribute("SAML_TXID") == null) {
            return "error";
        }
        if (BooleanUtils.toBoolean((Boolean)this.submitted)) {
            PluginHandler handler = new PluginHandler();
            String txId = (String)this.getCurrentSession().getAttribute("SAML_TXID");
            Boolean valid = handler.validateOTPToken(txId, this.token);
            if (valid.booleanValue()) {
                String email = (String)this.getCurrentSession().getAttribute("SAML_USERNAME");
                String password = (String)this.getCurrentSession().getAttribute("SAML_PASSWORD");
                String phone = (String)this.getCurrentSession().getAttribute("SAML_PHONE");
                String firstName = (String)this.getCurrentSession().getAttribute("SAML_FIRST_NAME");
                String lastName = (String)this.getCurrentSession().getAttribute("SAML_LAST_NAME");
                Customer customer = handler.createCustomer(email, password, phone, firstName, lastName, this.settings.getBaseUrl());
                this.settings.setCustomerId(customer.getCustomerId().toString());
                this.settings.setCustomerEmail(email);
                this.settings.setCustomerAPIKey(customer.getApiKey());
                this.settings.setCustomerTokenKey(customer.getTokenKey());
                this.settings.setCustomerRegisteredBefore209();
                this.getCurrentSession().removeAttribute("SAML_USERNAME");
                this.getCurrentSession().removeAttribute("SAML_PASSWORD");
                this.getCurrentSession().removeAttribute("SAML_PHONE");
                this.getCurrentSession().removeAttribute("SAML_FIRST_NAME");
                this.getCurrentSession().removeAttribute("SAML_LAST_NAME");
                this.getCurrentSession().removeAttribute("SAML_TXID");
                return "redirect";
            }
            this.addActionError(this.getText("samlsso.error.validate.token.invalid"));
            return "input";
        }
        return "success";
    }

    public Boolean getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(Boolean submitted) {
        this.submitted = submitted;
    }

    public void setSettings(SAMLSettings settings) {
        this.settings = settings;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Boolean getBackToRegister() {
        return this.backToRegister;
    }

    public void setBackToRegister(Boolean backToRegister) {
        this.backToRegister = backToRegister;
    }
}

