/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.confluence;

import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.spring.container.ContainerManager;
import com.miniorange.sso.saml.SAMLUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class SAMLSettings {
    private PluginSettings pluginSettings;

    public String getSsoServiceUrl() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.SSO_URL")));
    }

    public void setSsoServiceUrl(String ssoServiceUrl) {
        this.pluginSettings.put("miniorange.saml.SSO_URL", (Object)StringUtils.trimToEmpty((String)ssoServiceUrl));
    }

    public String getSloServiceUrl() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.SLO_URL")));
    }

    public void setSloServiceUrl(String sloServiceUrl) {
        this.pluginSettings.put("miniorange.saml.SLO_URL", (Object)StringUtils.trimToEmpty((String)sloServiceUrl));
    }

    public String getIdpEntityId() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.IDP_ENTITY_ID")));
    }

    public void setIdpEntityId(String idpEntityId) {
        this.pluginSettings.put("miniorange.saml.IDP_ENTITY_ID", (Object)StringUtils.trimToEmpty((String)idpEntityId));
    }

    public String getX509Certificate() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.X509_CERTIFICATE")));
    }

    public void setX509Certificate(String x509Certificate) {
        this.pluginSettings.put("miniorange.saml.X509_CERTIFICATE", (Object)SAMLUtils.serializePublicCertificate(x509Certificate));
    }

    public String getUsernameAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.USERNAME_ATTRIBUTE")), (CharSequence)"NameID");
    }

    public void setUsernameAttribute(String usernameAttribute) {
        this.pluginSettings.put("miniorange.saml.USERNAME_ATTRIBUTE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)usernameAttribute, (CharSequence)"NameID"))));
    }

    public String getEmailAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.EMAIL_ATTRIBUTE")), (CharSequence)"NameID");
    }

    public void setEmailAttribute(String emailAttribute) {
        this.pluginSettings.put("miniorange.saml.EMAIL_ATTRIBUTE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)emailAttribute, (CharSequence)"NameID"))));
    }

    public String getDefaultGroup() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.DEFAULT_GROUP")));
    }

    public void setDefaultGroup(String defaultGroup) {
        this.pluginSettings.put("miniorange.saml.DEFAULT_GROUP", (Object)StringUtils.trimToEmpty((String)defaultGroup));
    }

    public Boolean getDefaultLoginDisabled() {
        return BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.DISABLE_DEFAULT_LOGIN")));
    }

    public void setDefaultLoginDisabled(Boolean defaultLoginDisabled) {
        this.pluginSettings.put("miniorange.saml.DISABLE_DEFAULT_LOGIN", (Object)BooleanUtils.toString((Boolean)defaultLoginDisabled, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getBackdoorEnabled() {
        return BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.ENABLE_BACKDOOR")));
    }

    public void setBackdoorEnabled(Boolean backdoorEnabled) {
        this.pluginSettings.put("miniorange.saml.ENABLE_BACKDOOR", (Object)BooleanUtils.toString((Boolean)backdoorEnabled, (String)"true", (String)"false", (String)"true"));
    }

    public String getLoginButtonText() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.LOGIN_BUTTON_TEXT")), (CharSequence)"Use Corporate Login");
    }

    public void setLoginButtonText(String loginButtonText) {
        this.pluginSettings.put("miniorange.saml.LOGIN_BUTTON_TEXT", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)loginButtonText, (CharSequence)"Use Corporate Login"))));
    }

    public String getBaseUrl() {
        SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
        return settingsManager.getGlobalSettings().getBaseUrl();
    }

    public String getDashboardUrl() {
        return this.getBaseUrl().concat(this.getDashboardServletPath());
    }

    public String getDashboardServletPath() {
        return "/index.action#all-updates";
    }

    public String getLoginServletUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/saml/auth");
    }

    public String getRegisterActionUrl() {
        return this.getBaseUrl().concat("/secure/admin/samlsso.register.jspa");
    }

    public String getConfigureActionUrl() {
        return this.getBaseUrl().concat("/secure/admin/samlsso.configure.jspa");
    }

    public String getMiniorangeUrl() {
        return "https://auth.miniorange.com/moas";
    }

    public String getCustomerID() {
        String customerId = StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.CUSTOMER_ID")));
        return customerId;
    }

    public void setCustomerId(String customerId) {
        this.pluginSettings.put("miniorange.saml.CUSTOMER_ID", (Object)customerId);
    }

    public String getCustomerEmail() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.CUSTOMER_EMAIL")));
    }

    public void setCustomerEmail(String email) {
        this.pluginSettings.put("miniorange.saml.CUSTOMER_EMAIL", (Object)StringUtils.trimToEmpty((String)email));
    }

    public String getCustomerAPIKey() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.CUSTOMER_API_KEY")));
    }

    public void setCustomerAPIKey(String customerId) {
        this.pluginSettings.put("miniorange.saml.CUSTOMER_API_KEY", (Object)customerId);
    }

    public String getCustomerTokenKey() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.CUSTOMER_TOKEN_KEY")));
    }

    public void setCustomerTokenKey(String customerId) {
        this.pluginSettings.put("miniorange.saml.CUSTOMER_TOKEN_KEY", (Object)customerId);
    }

    public Boolean isCustomerRegistered() {
        if (StringUtils.isBlank((CharSequence)this.getCustomerID()) || StringUtils.isBlank((CharSequence)this.getCustomerEmail())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean getCustomerRegisteredBefore209() {
        if (StringUtils.isBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.CUSTOMER_BEFORE_209")))) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.CUSTOMER_BEFORE_209")));
    }

    public void setCustomerRegisteredBefore209() {
        this.pluginSettings.put("miniorange.saml.CUSTOMER_BEFORE_209", (Object)"false");
    }

    public void removeCustomerAccount() {
        this.pluginSettings.remove("miniorange.saml.CUSTOMER_ID");
        this.pluginSettings.remove("miniorange.saml.CUSTOMER_EMAIL");
        this.pluginSettings.remove("miniorange.saml.CUSTOMER_API_KEY");
        this.pluginSettings.remove("miniorange.saml.CUSTOMER_TOKEN_KEY");
    }

    public void setPluginSettingsFactory(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }
}

