/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.confluence;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.miniorange.sso.saml.Customer;
import com.miniorange.sso.saml.PluginException;
import com.miniorange.sso.saml.PluginHandler;
import com.miniorange.sso.saml.confluence.SAMLSettings;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RegisterAction
extends ConfluenceActionSupport {
    private static final long serialVersionUID = 1L;
    private static Log LOGGER = LogFactory.getLog(RegisterAction.class);
    private Boolean submitted;
    private SAMLSettings settings;
    private String email;
    private String phone;
    private String password;
    private String confirmPassword;
    private String firstName;
    private String lastName;

    public void validate() {
        if (!BooleanUtils.toBoolean((Boolean)this.submitted)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.email)) {
            this.addActionError(this.getText("samlsso.error.register.email.empty"));
        }
        if (StringUtils.isBlank((CharSequence)this.password)) {
            this.addActionError(this.getText("samlsso.error.register.password.empty"));
        }
        if (StringUtils.isBlank((CharSequence)this.confirmPassword)) {
            this.addActionError(this.getText("samlsso.error.register.confirmpassword.empty"));
        }
        if (!StringUtils.equals((CharSequence)this.password, (CharSequence)this.confirmPassword)) {
            this.addActionError(this.getText("samlsso.error.register.password.mismatch"));
        }
    }

    public String execute() {
        if (this.settings.isCustomerRegistered().booleanValue()) {
            try {
                return "redirect";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (BooleanUtils.toBoolean((Boolean)this.submitted)) {
            try {
                PluginHandler handler = new PluginHandler();
                Boolean exists = handler.checkIfCustomerExists(this.email);
                if (exists.booleanValue()) {
                    try {
                        Customer customer = handler.fetchCustomer(this.email, this.password);
                        this.settings.setCustomerId(customer.getCustomerId().toString());
                        this.settings.setCustomerEmail(customer.getEmail());
                        this.settings.setCustomerAPIKey(customer.getApiKey());
                        this.settings.setCustomerTokenKey(customer.getTokenKey());
                        this.settings.setCustomerRegisteredBefore209();
                        return "error";
                    }
                    catch (PluginException e) {
                        this.addActionError("Customer Fetch failed.");
                        return "input";
                    }
                }
                String txId = handler.sendOTPToken(this.email);
                this.getCurrentSession().setAttribute("SAML_USERNAME", (Object)this.email);
                this.getCurrentSession().setAttribute("SAML_PASSWORD", (Object)this.password);
                this.getCurrentSession().setAttribute("SAML_PHONE", (Object)this.phone);
                this.getCurrentSession().setAttribute("SAML_FIRST_NAME", (Object)this.firstName);
                this.getCurrentSession().setAttribute("SAML_LAST_NAME", (Object)this.lastName);
                this.getCurrentSession().setAttribute("SAML_TXID", (Object)txId);
                if (txId != null) {
                    return "redirect";
                }
                this.addActionError(this.getText("samlsso.error.register.failed.customer.creation"));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addActionError("There was an error processing your request. Please verify that your server is connected to internet. To skip registration, contact us at info@miniorange.com");
                return "input";
            }
        }
        return "success";
    }

    public Boolean getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(Boolean submitted) {
        this.submitted = submitted;
    }

    public SAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(SAMLSettings settings) {
        this.settings = settings;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }
}

