/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.confluence.user;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.confluence.user.ConfluenceUserProfile;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

public class ConfluenceUserManager
implements UserManager {
    private final UserAccessor userAccessor;
    private final CrowdService crowdService;
    private final PermissionManager permissionManager;

    public ConfluenceUserManager(UserAccessor userAccessor, CrowdService crowdService, PermissionManager permissionManager) {
        this.userAccessor = userAccessor;
        this.crowdService = crowdService;
        this.permissionManager = permissionManager;
    }

    public String getRemoteUsername() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null) {
            return user.getName();
        }
        return null;
    }

    @Nullable
    public UserProfile getRemoteUser() {
        return this.getUserProfile(AuthenticatedUserThreadLocal.get());
    }

    @Nullable
    public UserKey getRemoteUserKey() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return null;
        }
        return user.getKey();
    }

    public boolean isSystemAdmin(String username) {
        return this.isSystemAdmin(this.userAccessor.getUserByName(username));
    }

    public boolean isSystemAdmin(@Nullable UserKey userKey) {
        if (userKey == null) {
            return false;
        }
        return this.isSystemAdmin(this.userAccessor.getExistingUserByKey(userKey));
    }

    private boolean isSystemAdmin(ConfluenceUser user) {
        return user != null && this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }

    public boolean authenticate(String username, String password) {
        ConfluenceUser user = this.userAccessor.getUserByName(username);
        return user != null && this.userAccessor.authenticate(user.getName(), password);
    }

    public boolean isUserInGroup(String username, String group) {
        return this.userAccessor.hasMembership(group, username);
    }

    public boolean isUserInGroup(@Nullable UserKey userKey, @Nullable String groupName) {
        if (userKey == null) {
            return false;
        }
        Group group = this.userAccessor.getGroup(groupName);
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(userKey);
        return this.userAccessor.hasMembership(group, (User)user);
    }

    public String getRemoteUsername(HttpServletRequest request) {
        return this.getRemoteUsername();
    }

    @Nullable
    public UserProfile getRemoteUser(HttpServletRequest httpServletRequest) {
        return this.getRemoteUser();
    }

    @Nullable
    public UserKey getRemoteUserKey(HttpServletRequest httpServletRequest) {
        return this.getRemoteUserKey();
    }

    public ConfluenceUser resolve(String username) {
        return this.userAccessor.getUserByName(username);
    }

    public Iterable<String> findGroupNamesByPrefix(String prefix, int startIndex, int maxResults) {
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)prefix)).startingAt(startIndex).returningAtMost(maxResults);
        return this.crowdService.search((Query)query);
    }

    public boolean isAdmin(String username) {
        ConfluenceUser user = this.userAccessor.getUserByName(username);
        return user != null && this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public boolean isAdmin(@Nullable UserKey userKey) {
        if (userKey == null) {
            return false;
        }
        return this.isAdmin(this.userAccessor.getExistingUserByKey(userKey));
    }

    private boolean isAdmin(ConfluenceUser user) {
        return user != null && this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public UserProfile getUserProfile(String username) {
        return this.getUserProfile(this.userAccessor.getUserByName(username));
    }

    @Nullable
    public UserProfile getUserProfile(@Nullable UserKey userKey) {
        if (userKey == null) {
            return null;
        }
        return this.getUserProfile(this.userAccessor.getUserByKey(userKey));
    }

    private UserProfile getUserProfile(@Nullable ConfluenceUser user) {
        return null == user ? null : new ConfluenceUserProfile(user, this.userAccessor.getUserProfilePicture((User)user));
    }
}

