// node_modules/@atlassian/aui/src/js/aui/banner.js
(typeof window === 'undefined' ? global : window).__56273bd66528300b93aac570e670c5e3 = (function () {
  var module = {
    exports: {}
  };
  var exports = module.exports;
  
  'use strict';
  
  Object.defineProperty(exports, "__esModule", {
      value: true
  });
  
  var _jquery = __205998b249afc65053be53fe079b2622;
  
  var _jquery2 = _interopRequireDefault(_jquery);
  
  var _animation = __2ed95b5559992bbb8aa930ba13cf5c0e;
  
  var _amdify = __dc68b9274c05b6370900ab8f60c2035d;
  
  var _amdify2 = _interopRequireDefault(_amdify);
  
  var _globalize = __90e6b3a7b5f251fe6bee9d0accee9418;
  
  var _globalize2 = _interopRequireDefault(_globalize);
  
  var _template = __6be9381b9436165046caa8b76f89950c;
  
  var _template2 = _interopRequireDefault(_template);
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
  
  var ID_BANNER_CONTAINER = 'header';
  
  function banner(options) {
      var $banner = renderBannerElement(options);
  
      pruneBannerContainer();
      insertBanner($banner);
  
      return $banner[0];
  }
  
  function renderBannerElement(options) {
      var html = '<div class="aui-banner aui-banner-{type}" role="banner">' + '{body}' + '</div>';
  
      var $banner = (0, _jquery2.default)((0, _template2.default)(html).fill({
          'type': 'error',
          'body:html': options.body || ''
      }).toString());
  
      return $banner;
  }
  
  function pruneBannerContainer() {
      var $container = findContainer();
      var $allBanners = $container.find('.aui-banner');
  
      $allBanners.get().forEach(function (banner) {
          var isBannerAriaHidden = banner.getAttribute('aria-hidden') === 'true';
          if (isBannerAriaHidden) {
              (0, _jquery2.default)(banner).remove();
          }
      });
  }
  
  function findContainer() {
      return (0, _jquery2.default)('#' + ID_BANNER_CONTAINER);
  }
  
  function insertBanner($banner) {
      var $bannerContainer = findContainer();
      if (!$bannerContainer.length) {
          throw new Error('You must implement the application header');
      }
  
      $banner.prependTo($bannerContainer);
      (0, _animation.recomputeStyle)($banner);
      $banner.attr('aria-hidden', 'false');
  }
  
  (0, _amdify2.default)('aui/banner', banner);
  (0, _globalize2.default)('banner', banner);
  exports.default = banner;
  module.exports = exports['default'];
  
  return module.exports;
}).call(this);