/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.confluence.license;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.ConfigurationException;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.license.exception.LicenseException;
import com.atlassian.sal.api.i18n.InvalidOperationException;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.license.MultiProductLicenseDetails;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import com.atlassian.sal.api.validate.ValidationResult;
import com.atlassian.sal.confluence.license.MultiProductLicenseDetailsImpl;
import com.atlassian.sal.confluence.license.SingleProductDetailsViewImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConfluenceLicenseHandler
implements LicenseHandler {
    public static final String UNSUPPORTED_PRODUCT_KEY_MESSAGE = "Unsupported product key ";
    private ConfluenceSidManager sidManager;
    private LicenseService licenseService;
    private ApplicationConfiguration applicationConfiguration;

    public ConfluenceLicenseHandler(ConfluenceSidManager sidManager, LicenseService licenseService, ApplicationConfiguration applicationConfiguration) {
        this.sidManager = sidManager;
        this.licenseService = licenseService;
        this.applicationConfiguration = applicationConfiguration;
    }

    @Deprecated
    public void setLicense(String licenseString) {
        try {
            this.licenseService.install(licenseString);
        }
        catch (LicenseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getServerId() {
        try {
            return this.sidManager.getSid();
        }
        catch (ConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getSupportEntitlementNumber() {
        return this.licenseService.retrieve().getSupportEntitlementNumber();
    }

    public boolean hostAllowsMultipleLicenses() {
        return false;
    }

    public boolean hostAllowsCustomProducts() {
        return false;
    }

    public Set<String> getProductKeys() {
        return Collections.singleton("conf");
    }

    public void addProductLicense(String productKey, String license) throws InvalidOperationException {
        if (!"conf".equalsIgnoreCase(productKey)) {
            String message = UNSUPPORTED_PRODUCT_KEY_MESSAGE + productKey;
            throw new InvalidOperationException(message, message);
        }
        try {
            this.licenseService.install(license);
        }
        catch (LicenseException e) {
            throw new InvalidOperationException(e.getMessage(), e.getLocalizedMessage());
        }
    }

    public void removeProductLicense(String productKey) throws InvalidOperationException {
        String message = "Cannot remove Confluence license";
        throw new InvalidOperationException("Cannot remove Confluence license", "Cannot remove Confluence license");
    }

    @Nonnull
    public ValidationResult validateProductLicense(String productKey, String license, Locale locale) {
        if (!"conf".equalsIgnoreCase(productKey)) {
            String message = UNSUPPORTED_PRODUCT_KEY_MESSAGE + productKey;
            return ValidationResult.withErrorMessages(Collections.singleton(message));
        }
        try {
            this.licenseService.validate(license);
            return ValidationResult.valid();
        }
        catch (LicenseException e) {
            return ValidationResult.withErrorMessages(Collections.singleton("Failed to validate license: " + e.getMessage()));
        }
    }

    @Nonnull
    public SortedSet<String> getAllSupportEntitlementNumbers() {
        return new TreeSet<String>(Collections.singleton(this.licenseService.retrieve().getSupportEntitlementNumber()));
    }

    @Nullable
    public String getRawProductLicense(String productKey) {
        return (String)this.applicationConfiguration.getProperty((Object)"atlassian.license.message");
    }

    @Nullable
    public SingleProductLicenseDetailsView getProductLicenseDetails(String productKey) {
        if (!"conf".equalsIgnoreCase(productKey)) {
            throw new IllegalArgumentException(UNSUPPORTED_PRODUCT_KEY_MESSAGE + productKey);
        }
        return new SingleProductDetailsViewImpl(this.licenseService.retrieve());
    }

    @Nonnull
    public Collection<MultiProductLicenseDetails> getAllProductLicenses() {
        return Collections.singleton(new MultiProductLicenseDetailsImpl(this.licenseService.retrieve()));
    }

    @Nonnull
    public MultiProductLicenseDetails decodeLicenseDetails(String license) {
        return new MultiProductLicenseDetailsImpl(this.licenseService.validate(license));
    }
}

