/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.search.rest;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.plugins.search.FpUtils;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchQueryBuilder;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchResultList;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchService;
import com.atlassian.servicedesk.plugins.search.error.ErrorHelper;
import com.atlassian.servicedesk.plugins.search.rest.response.RequestTypeSearchResultListResponse;
import com.atlassian.servicedesk.plugins.search.rest.response.RequestTypeSearchResultResponse;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="/search/request-type")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class RequestTypeSearchResource {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final RequestTypeSearchService requestTypeSearchService;
    private final ErrorHelper errorHelper;
    private final RestResponseHelper restResponseHelper;

    protected RequestTypeSearchResource(JiraAuthenticationContext jiraAuthenticationContext, RequestTypeSearchService requestTypeSearchService, ErrorHelper errorHelper, RestResponseHelper restResponseHelper) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.requestTypeSearchService = requestTypeSearchService;
        this.errorHelper = errorHelper;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    public Response searchRequestTypes(@QueryParam(value="query") String searchQuery, @QueryParam(value="resultLimit") Integer resultLimit, @QueryParam(value="serviceDeskId") Integer serviceDeskId) {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        Either responseEither = Steps.begin(this.validateSearchQuery(searchQuery)).then(validQuery -> this.validateResultLimit(resultLimit)).then((validQuery, validLimit) -> this.validateServiceDeskId(serviceDeskId)).then((validQuery, validLimit, validSdId) -> this.searchRequestTypes(loggedInUser, (String)validQuery, (Option<Integer>)validLimit, (Option<Integer>)validSdId)).yield((validQuery, validLimit, validSdId, resultList) -> {
            List<RequestTypeSearchResultResponse> requestTypeSearchResultResponses = resultList.getRequestTypeSearchResults().stream().map(RequestTypeSearchResultResponse::new).collect(Collectors.toList());
            return this.restResponseHelper.ok((Object)new RequestTypeSearchResultListResponse(requestTypeSearchResultResponses));
        });
        return (Response)Eithers.merge((Either)responseEither.leftMap(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0)));
    }

    private Either<AnError, RequestTypeSearchResultList> searchRequestTypes(ApplicationUser user, String searchQuery, Option<Integer> resultLimit, Option<Integer> serviceDeskId) {
        RequestTypeSearchQueryBuilder requestTypeSearchQueryBuilder = RequestTypeSearchQueryBuilder.newQuery((String)searchQuery);
        resultLimit.forEach(arg_0 -> ((RequestTypeSearchQueryBuilder)requestTypeSearchQueryBuilder).withLimit(arg_0));
        serviceDeskId.forEach(arg_0 -> ((RequestTypeSearchQueryBuilder)requestTypeSearchQueryBuilder).searchOnlyServiceDesk(arg_0));
        return this.requestTypeSearchService.searchRequestTypes(user, requestTypeSearchQueryBuilder.build());
    }

    private Either<AnError, Option<Integer>> validateServiceDeskId(@Nullable Integer serviceDeskId) {
        return Either.right((Object)Option.option((Object)serviceDeskId));
    }

    private Either<AnError, String> validateSearchQuery(@Nullable String searchQuery) {
        if (StringUtils.isBlank((String)searchQuery)) {
            return this.errorHelper.emptyQueryError();
        }
        return Either.right((Object)searchQuery);
    }

    private Either<AnError, Option<Integer>> validateResultLimit(@Nullable Integer resultLimit) {
        Option resultLimitOption = Option.option((Object)resultLimit);
        return FpUtils.swapEitherAndOption(resultLimitOption.map(nonNullLimit -> {
            if (nonNullLimit < 0) {
                return this.errorHelper.invalidResultLimit((int)nonNullLimit);
            }
            return Either.right((Object)nonNullLimit);
        }));
    }
}

