/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.search.requesttype.algorithm.jql.base;

import com.google.common.collect.Sets;
import io.atlassian.fugue.Iterables;
import java.util.Set;
import javax.annotation.Nonnull;

class SetBatcher<T> {
    private final int batchSize;
    private final Set<T> set;
    private int currentPointer = 0;

    SetBatcher(int batchSize, @Nonnull Set<T> set) {
        this.batchSize = batchSize;
        this.set = Sets.newLinkedHashSet(set);
    }

    Set<T> next() {
        Iterable batch = Iterables.take((int)this.batchSize, (Iterable)Iterables.drop((int)this.currentPointer, this.set));
        this.currentPointer += this.batchSize;
        return Sets.newLinkedHashSet((Iterable)batch);
    }

    boolean hasMore() {
        return this.currentPointer < this.set.size();
    }
}

